package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSatelliteRequest(satelliteId: Uuid) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.GetSatelliteRequest = {
    import GetSatelliteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.GetSatelliteRequest
      .builder()
      .satelliteId(Uuid.unwrap(satelliteId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.GetSatelliteRequest.ReadOnly =
    zio.aws.groundstation.model.GetSatelliteRequest.wrap(buildAwsValue())
}
object GetSatelliteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.GetSatelliteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.GetSatelliteRequest =
      zio.aws.groundstation.model.GetSatelliteRequest(satelliteId)
    def satelliteId: Uuid
    def getSatelliteId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(satelliteId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.GetSatelliteRequest
  ) extends zio.aws.groundstation.model.GetSatelliteRequest.ReadOnly {
    override val satelliteId: Uuid =
      zio.aws.groundstation.model.primitives.Uuid(impl.satelliteId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.GetSatelliteRequest
  ): zio.aws.groundstation.model.GetSatelliteRequest.ReadOnly = new Wrapper(
    impl
  )
}
