package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.ConfigArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetConfigResponse(
    configArn: ConfigArn,
    configData: zio.aws.groundstation.model.ConfigTypeData,
    configId: String,
    configType: Optional[zio.aws.groundstation.model.ConfigCapabilityType] =
      Optional.Absent,
    name: String,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.GetConfigResponse = {
    import GetConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.GetConfigResponse
      .builder()
      .configArn(ConfigArn.unwrap(configArn): java.lang.String)
      .configData(configData.buildAwsValue())
      .configId(configId: java.lang.String)
      .optionallyWith(configType.map(value => value.unwrap))(_.configType)
      .name(name: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.GetConfigResponse.ReadOnly =
    zio.aws.groundstation.model.GetConfigResponse.wrap(buildAwsValue())
}
object GetConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.GetConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.GetConfigResponse =
      zio.aws.groundstation.model.GetConfigResponse(
        configArn,
        configData.asEditable,
        configId,
        configType.map(value => value),
        name,
        tags.map(value => value)
      )
    def configArn: ConfigArn
    def configData: zio.aws.groundstation.model.ConfigTypeData.ReadOnly
    def configId: String
    def configType: Optional[zio.aws.groundstation.model.ConfigCapabilityType]
    def name: String
    def tags: Optional[Map[String, String]]
    def getConfigArn: ZIO[Any, Nothing, ConfigArn] = ZIO.succeed(configArn)
    def getConfigData: ZIO[
      Any,
      Nothing,
      zio.aws.groundstation.model.ConfigTypeData.ReadOnly
    ] = ZIO.succeed(configData)
    def getConfigId: ZIO[Any, Nothing, String] = ZIO.succeed(configId)
    def getConfigType
        : ZIO[Any, AwsError, zio.aws.groundstation.model.ConfigCapabilityType] =
      AwsError.unwrapOptionField("configType", configType)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.GetConfigResponse
  ) extends zio.aws.groundstation.model.GetConfigResponse.ReadOnly {
    override val configArn: ConfigArn =
      zio.aws.groundstation.model.primitives.ConfigArn(impl.configArn())
    override val configData
        : zio.aws.groundstation.model.ConfigTypeData.ReadOnly =
      zio.aws.groundstation.model.ConfigTypeData.wrap(impl.configData())
    override val configId: String = impl.configId(): String
    override val configType
        : Optional[zio.aws.groundstation.model.ConfigCapabilityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configType())
        .map(value =>
          zio.aws.groundstation.model.ConfigCapabilityType.wrap(value)
        )
    override val name: String = impl.name(): String
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.GetConfigResponse
  ): zio.aws.groundstation.model.GetConfigResponse.ReadOnly = new Wrapper(impl)
}
