package zio.aws.groundstation.model
import scala.jdk.CollectionConverters.*
sealed trait EphemerisStatus {
  def unwrap
      : software.amazon.awssdk.services.groundstation.model.EphemerisStatus
}
object EphemerisStatus {
  def wrap(
      value: software.amazon.awssdk.services.groundstation.model.EphemerisStatus
  ): zio.aws.groundstation.model.EphemerisStatus = value match {
    case software.amazon.awssdk.services.groundstation.model.EphemerisStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.groundstation.model.EphemerisStatus.VALIDATING =>
      val r = VALIDATING
      r
    case software.amazon.awssdk.services.groundstation.model.EphemerisStatus.INVALID =>
      val r = INVALID
      r
    case software.amazon.awssdk.services.groundstation.model.EphemerisStatus.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.groundstation.model.EphemerisStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.groundstation.model.EphemerisStatus.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.groundstation.model.EphemerisStatus.EXPIRED =>
      val r = EXPIRED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.groundstation.model.EphemerisStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EphemerisStatus =
      software.amazon.awssdk.services.groundstation.model.EphemerisStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object VALIDATING extends zio.aws.groundstation.model.EphemerisStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EphemerisStatus =
      software.amazon.awssdk.services.groundstation.model.EphemerisStatus.VALIDATING
  }
  case object INVALID extends zio.aws.groundstation.model.EphemerisStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EphemerisStatus =
      software.amazon.awssdk.services.groundstation.model.EphemerisStatus.INVALID
  }
  case object ERROR extends zio.aws.groundstation.model.EphemerisStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EphemerisStatus =
      software.amazon.awssdk.services.groundstation.model.EphemerisStatus.ERROR
  }
  case object ENABLED extends zio.aws.groundstation.model.EphemerisStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EphemerisStatus =
      software.amazon.awssdk.services.groundstation.model.EphemerisStatus.ENABLED
  }
  case object DISABLED extends zio.aws.groundstation.model.EphemerisStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EphemerisStatus =
      software.amazon.awssdk.services.groundstation.model.EphemerisStatus.DISABLED
  }
  case object EXPIRED extends zio.aws.groundstation.model.EphemerisStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EphemerisStatus =
      software.amazon.awssdk.services.groundstation.model.EphemerisStatus.EXPIRED
  }
}
