package zio.aws.groundstation.model
import scala.jdk.CollectionConverters.*
sealed trait EirpUnits {
  def unwrap: software.amazon.awssdk.services.groundstation.model.EirpUnits
}
object EirpUnits {
  def wrap(
      value: software.amazon.awssdk.services.groundstation.model.EirpUnits
  ): zio.aws.groundstation.model.EirpUnits = value match {
    case software.amazon.awssdk.services.groundstation.model.EirpUnits.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.groundstation.model.EirpUnits.D_BW =>
      val r = dBW
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.groundstation.model.EirpUnits {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EirpUnits =
      software.amazon.awssdk.services.groundstation.model.EirpUnits.UNKNOWN_TO_SDK_VERSION
  }
  case object dBW extends zio.aws.groundstation.model.EirpUnits {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EirpUnits =
      software.amazon.awssdk.services.groundstation.model.EirpUnits.D_BW
  }
}
