package zio.aws.groundstation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.groundstation.model.primitives.{
  EphemerisPriority,
  SafeName,
  Uuid,
  Timestamp
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeEphemerisResponse(
    creationTime: Optional[Timestamp] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent,
    ephemerisId: Optional[Uuid] = Optional.Absent,
    invalidReason: Optional[
      zio.aws.groundstation.model.EphemerisInvalidReason
    ] = Optional.Absent,
    name: Optional[SafeName] = Optional.Absent,
    priority: Optional[EphemerisPriority] = Optional.Absent,
    satelliteId: Optional[Uuid] = Optional.Absent,
    status: Optional[zio.aws.groundstation.model.EphemerisStatus] =
      Optional.Absent,
    suppliedData: Optional[
      zio.aws.groundstation.model.EphemerisTypeDescription
    ] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DescribeEphemerisResponse = {
    import DescribeEphemerisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DescribeEphemerisResponse
      .builder()
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        ephemerisId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.ephemerisId)
      .optionallyWith(invalidReason.map(value => value.unwrap))(_.invalidReason)
      .optionallyWith(
        name.map(value => SafeName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        priority.map(value => EphemerisPriority.unwrap(value): Integer)
      )(_.priority)
      .optionallyWith(
        satelliteId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.satelliteId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(suppliedData.map(value => value.buildAwsValue()))(
        _.suppliedData
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.DescribeEphemerisResponse.ReadOnly =
    zio.aws.groundstation.model.DescribeEphemerisResponse.wrap(buildAwsValue())
}
object DescribeEphemerisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DescribeEphemerisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.DescribeEphemerisResponse =
      zio.aws.groundstation.model.DescribeEphemerisResponse(
        creationTime.map(value => value),
        enabled.map(value => value),
        ephemerisId.map(value => value),
        invalidReason.map(value => value),
        name.map(value => value),
        priority.map(value => value),
        satelliteId.map(value => value),
        status.map(value => value),
        suppliedData.map(value => value.asEditable),
        tags.map(value => value)
      )
    def creationTime: Optional[Timestamp]
    def enabled: Optional[Boolean]
    def ephemerisId: Optional[Uuid]
    def invalidReason
        : Optional[zio.aws.groundstation.model.EphemerisInvalidReason]
    def name: Optional[SafeName]
    def priority: Optional[EphemerisPriority]
    def satelliteId: Optional[Uuid]
    def status: Optional[zio.aws.groundstation.model.EphemerisStatus]
    def suppliedData: Optional[
      zio.aws.groundstation.model.EphemerisTypeDescription.ReadOnly
    ]
    def tags: Optional[Map[String, String]]
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getEphemerisId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("ephemerisId", ephemerisId)
    def getInvalidReason: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.EphemerisInvalidReason
    ] = AwsError.unwrapOptionField("invalidReason", invalidReason)
    def getName: ZIO[Any, AwsError, SafeName] =
      AwsError.unwrapOptionField("name", name)
    def getPriority: ZIO[Any, AwsError, EphemerisPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getSatelliteId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("satelliteId", satelliteId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.groundstation.model.EphemerisStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSuppliedData: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.EphemerisTypeDescription.ReadOnly
    ] = AwsError.unwrapOptionField("suppliedData", suppliedData)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DescribeEphemerisResponse
  ) extends zio.aws.groundstation.model.DescribeEphemerisResponse.ReadOnly {
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.groundstation.model.primitives.Timestamp(value))
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val ephemerisId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.ephemerisId())
      .map(value => zio.aws.groundstation.model.primitives.Uuid(value))
    override val invalidReason
        : Optional[zio.aws.groundstation.model.EphemerisInvalidReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invalidReason())
        .map(value =>
          zio.aws.groundstation.model.EphemerisInvalidReason.wrap(value)
        )
    override val name: Optional[SafeName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.groundstation.model.primitives.SafeName(value))
    override val priority: Optional[EphemerisPriority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value =>
        zio.aws.groundstation.model.primitives.EphemerisPriority(value)
      )
    override val satelliteId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.satelliteId())
      .map(value => zio.aws.groundstation.model.primitives.Uuid(value))
    override val status: Optional[zio.aws.groundstation.model.EphemerisStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.groundstation.model.EphemerisStatus.wrap(value))
    override val suppliedData: Optional[
      zio.aws.groundstation.model.EphemerisTypeDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.suppliedData())
      .map(value =>
        zio.aws.groundstation.model.EphemerisTypeDescription.wrap(value)
      )
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DescribeEphemerisResponse
  ): zio.aws.groundstation.model.DescribeEphemerisResponse.ReadOnly =
    new Wrapper(impl)
}
