package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.{
  S3VersionId,
  S3ObjectKey,
  S3BucketName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3Object(
    bucket: Optional[S3BucketName] = Optional.Absent,
    key: Optional[S3ObjectKey] = Optional.Absent,
    version: Optional[S3VersionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.S3Object = {
    import S3Object.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.S3Object
      .builder()
      .optionallyWith(
        bucket.map(value => S3BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        key.map(value => S3ObjectKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        version.map(value => S3VersionId.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.S3Object.ReadOnly =
    zio.aws.groundstation.model.S3Object.wrap(buildAwsValue())
}
object S3Object {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.S3Object
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.S3Object =
      zio.aws.groundstation.model.S3Object(
        bucket.map(value => value),
        key.map(value => value),
        version.map(value => value)
      )
    def bucket: Optional[S3BucketName]
    def key: Optional[S3ObjectKey]
    def version: Optional[S3VersionId]
    def getBucket: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKey: ZIO[Any, AwsError, S3ObjectKey] =
      AwsError.unwrapOptionField("key", key)
    def getVersion: ZIO[Any, AwsError, S3VersionId] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.S3Object
  ) extends zio.aws.groundstation.model.S3Object.ReadOnly {
    override val bucket: Optional[S3BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.groundstation.model.primitives.S3BucketName(value))
    override val key: Optional[S3ObjectKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.groundstation.model.primitives.S3ObjectKey(value))
    override val version: Optional[S3VersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.groundstation.model.primitives.S3VersionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.S3Object
  ): zio.aws.groundstation.model.S3Object.ReadOnly = new Wrapper(impl)
}
