package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListEphemeridesResponse(
    ephemerides: Optional[Iterable[zio.aws.groundstation.model.EphemerisItem]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ListEphemeridesResponse = {
    import ListEphemeridesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ListEphemeridesResponse
      .builder()
      .optionallyWith(
        ephemerides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ephemerides)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ListEphemeridesResponse.ReadOnly =
    zio.aws.groundstation.model.ListEphemeridesResponse.wrap(buildAwsValue())
}
object ListEphemeridesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ListEphemeridesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ListEphemeridesResponse =
      zio.aws.groundstation.model.ListEphemeridesResponse(
        ephemerides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def ephemerides
        : Optional[List[zio.aws.groundstation.model.EphemerisItem.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getEphemerides: ZIO[Any, AwsError, List[
      zio.aws.groundstation.model.EphemerisItem.ReadOnly
    ]] = AwsError.unwrapOptionField("ephemerides", ephemerides)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ListEphemeridesResponse
  ) extends zio.aws.groundstation.model.ListEphemeridesResponse.ReadOnly {
    override val ephemerides
        : Optional[List[zio.aws.groundstation.model.EphemerisItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ephemerides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.groundstation.model.EphemerisItem.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.groundstation.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ListEphemeridesResponse
  ): zio.aws.groundstation.model.ListEphemeridesResponse.ReadOnly = new Wrapper(
    impl
  )
}
