package zio.aws.groundstation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.groundstation.model.primitives.{
  Uuid,
  PaginationToken,
  PaginationMaxResults,
  Timestamp
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListEphemeridesRequest(
    endTime: Timestamp,
    maxResults: Optional[PaginationMaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    satelliteId: Uuid,
    startTime: Timestamp,
    statusList: Optional[
      Iterable[zio.aws.groundstation.model.EphemerisStatus]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest = {
    import ListEphemeridesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest
      .builder()
      .endTime(Timestamp.unwrap(endTime): Instant)
      .optionallyWith(
        maxResults.map(value => PaginationMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .satelliteId(Uuid.unwrap(satelliteId): java.lang.String)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .optionallyWith(
        statusList.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statusListWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ListEphemeridesRequest.ReadOnly =
    zio.aws.groundstation.model.ListEphemeridesRequest.wrap(buildAwsValue())
}
object ListEphemeridesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ListEphemeridesRequest =
      zio.aws.groundstation.model.ListEphemeridesRequest(
        endTime,
        maxResults.map(value => value),
        nextToken.map(value => value),
        satelliteId,
        startTime,
        statusList.map(value => value)
      )
    def endTime: Timestamp
    def maxResults: Optional[PaginationMaxResults]
    def nextToken: Optional[PaginationToken]
    def satelliteId: Uuid
    def startTime: Timestamp
    def statusList: Optional[List[zio.aws.groundstation.model.EphemerisStatus]]
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getMaxResults: ZIO[Any, AwsError, PaginationMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSatelliteId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(satelliteId)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getStatusList: ZIO[Any, AwsError, List[
      zio.aws.groundstation.model.EphemerisStatus
    ]] = AwsError.unwrapOptionField("statusList", statusList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest
  ) extends zio.aws.groundstation.model.ListEphemeridesRequest.ReadOnly {
    override val endTime: Timestamp =
      zio.aws.groundstation.model.primitives.Timestamp(impl.endTime())
    override val maxResults: Optional[PaginationMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.groundstation.model.primitives.PaginationMaxResults(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.groundstation.model.primitives.PaginationToken(value)
      )
    override val satelliteId: Uuid =
      zio.aws.groundstation.model.primitives.Uuid(impl.satelliteId())
    override val startTime: Timestamp =
      zio.aws.groundstation.model.primitives.Timestamp(impl.startTime())
    override val statusList
        : Optional[List[zio.aws.groundstation.model.EphemerisStatus]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.groundstation.model.EphemerisStatus.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest
  ): zio.aws.groundstation.model.ListEphemeridesRequest.ReadOnly = new Wrapper(
    impl
  )
}
