package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetMissionProfileRequest(missionProfileId: Uuid) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.GetMissionProfileRequest = {
    import GetMissionProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.GetMissionProfileRequest
      .builder()
      .missionProfileId(Uuid.unwrap(missionProfileId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.GetMissionProfileRequest.ReadOnly =
    zio.aws.groundstation.model.GetMissionProfileRequest.wrap(buildAwsValue())
}
object GetMissionProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.GetMissionProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.GetMissionProfileRequest =
      zio.aws.groundstation.model.GetMissionProfileRequest(missionProfileId)
    def missionProfileId: Uuid
    def getMissionProfileId: ZIO[Any, Nothing, Uuid] =
      ZIO.succeed(missionProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.GetMissionProfileRequest
  ) extends zio.aws.groundstation.model.GetMissionProfileRequest.ReadOnly {
    override val missionProfileId: Uuid =
      zio.aws.groundstation.model.primitives.Uuid(impl.missionProfileId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.GetMissionProfileRequest
  ): zio.aws.groundstation.model.GetMissionProfileRequest.ReadOnly =
    new Wrapper(impl)
}
