package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDataflowEndpointGroupRequest(
    dataflowEndpointGroupId: Uuid
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupRequest = {
    import GetDataflowEndpointGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupRequest
      .builder()
      .dataflowEndpointGroupId(
        Uuid.unwrap(dataflowEndpointGroupId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.GetDataflowEndpointGroupRequest.ReadOnly =
    zio.aws.groundstation.model.GetDataflowEndpointGroupRequest
      .wrap(buildAwsValue())
}
object GetDataflowEndpointGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.groundstation.model.GetDataflowEndpointGroupRequest =
      zio.aws.groundstation.model
        .GetDataflowEndpointGroupRequest(dataflowEndpointGroupId)
    def dataflowEndpointGroupId: Uuid
    def getDataflowEndpointGroupId: ZIO[Any, Nothing, Uuid] =
      ZIO.succeed(dataflowEndpointGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupRequest
  ) extends zio.aws.groundstation.model.GetDataflowEndpointGroupRequest.ReadOnly {
    override val dataflowEndpointGroupId: Uuid =
      zio.aws.groundstation.model.primitives
        .Uuid(impl.dataflowEndpointGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupRequest
  ): zio.aws.groundstation.model.GetDataflowEndpointGroupRequest.ReadOnly =
    new Wrapper(impl)
}
