package zio.aws.groundstation.model
import scala.jdk.CollectionConverters.*
sealed trait FrequencyUnits {
  def unwrap: software.amazon.awssdk.services.groundstation.model.FrequencyUnits
}
object FrequencyUnits {
  def wrap(
      value: software.amazon.awssdk.services.groundstation.model.FrequencyUnits
  ): zio.aws.groundstation.model.FrequencyUnits = value match {
    case software.amazon.awssdk.services.groundstation.model.FrequencyUnits.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.groundstation.model.FrequencyUnits.G_HZ =>
      val r = GHz
      r
    case software.amazon.awssdk.services.groundstation.model.FrequencyUnits.M_HZ =>
      val r = MHz
      r
    case software.amazon.awssdk.services.groundstation.model.FrequencyUnits.K_HZ =>
      val r = kHz
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.groundstation.model.FrequencyUnits {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.FrequencyUnits =
      software.amazon.awssdk.services.groundstation.model.FrequencyUnits.UNKNOWN_TO_SDK_VERSION
  }
  case object GHz extends zio.aws.groundstation.model.FrequencyUnits {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.FrequencyUnits =
      software.amazon.awssdk.services.groundstation.model.FrequencyUnits.G_HZ
  }
  case object MHz extends zio.aws.groundstation.model.FrequencyUnits {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.FrequencyUnits =
      software.amazon.awssdk.services.groundstation.model.FrequencyUnits.M_HZ
  }
  case object kHz extends zio.aws.groundstation.model.FrequencyUnits {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.FrequencyUnits =
      software.amazon.awssdk.services.groundstation.model.FrequencyUnits.K_HZ
  }
}
