package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EndpointDetails(
    endpoint: Optional[zio.aws.groundstation.model.DataflowEndpoint] =
      Optional.Absent,
    securityDetails: Optional[zio.aws.groundstation.model.SecurityDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.EndpointDetails = {
    import EndpointDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.EndpointDetails
      .builder()
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(securityDetails.map(value => value.buildAwsValue()))(
        _.securityDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.EndpointDetails.ReadOnly =
    zio.aws.groundstation.model.EndpointDetails.wrap(buildAwsValue())
}
object EndpointDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.EndpointDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.EndpointDetails =
      zio.aws.groundstation.model.EndpointDetails(
        endpoint.map(value => value.asEditable),
        securityDetails.map(value => value.asEditable)
      )
    def endpoint
        : Optional[zio.aws.groundstation.model.DataflowEndpoint.ReadOnly]
    def securityDetails
        : Optional[zio.aws.groundstation.model.SecurityDetails.ReadOnly]
    def getEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.DataflowEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("endpoint", endpoint)
    def getSecurityDetails: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.SecurityDetails.ReadOnly
    ] = AwsError.unwrapOptionField("securityDetails", securityDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.EndpointDetails
  ) extends zio.aws.groundstation.model.EndpointDetails.ReadOnly {
    override val endpoint
        : Optional[zio.aws.groundstation.model.DataflowEndpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoint())
        .map(value => zio.aws.groundstation.model.DataflowEndpoint.wrap(value))
    override val securityDetails
        : Optional[zio.aws.groundstation.model.SecurityDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityDetails())
        .map(value => zio.aws.groundstation.model.SecurityDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.EndpointDetails
  ): zio.aws.groundstation.model.EndpointDetails.ReadOnly = new Wrapper(impl)
}
