package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteMissionProfileRequest(missionProfileId: Uuid) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileRequest = {
    import DeleteMissionProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileRequest
      .builder()
      .missionProfileId(Uuid.unwrap(missionProfileId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.DeleteMissionProfileRequest.ReadOnly =
    zio.aws.groundstation.model.DeleteMissionProfileRequest
      .wrap(buildAwsValue())
}
object DeleteMissionProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.DeleteMissionProfileRequest =
      zio.aws.groundstation.model.DeleteMissionProfileRequest(missionProfileId)
    def missionProfileId: Uuid
    def getMissionProfileId: ZIO[Any, Nothing, Uuid] =
      ZIO.succeed(missionProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileRequest
  ) extends zio.aws.groundstation.model.DeleteMissionProfileRequest.ReadOnly {
    override val missionProfileId: Uuid =
      zio.aws.groundstation.model.primitives.Uuid(impl.missionProfileId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileRequest
  ): zio.aws.groundstation.model.DeleteMissionProfileRequest.ReadOnly =
    new Wrapper(impl)
}
