package zio.aws.groundstation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.groundstation.model.primitives.{
  SafeName,
  Timestamp,
  Uuid,
  KeyArn,
  CustomerEphemerisPriority
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateEphemerisRequest(
    enabled: Optional[Boolean] = Optional.Absent,
    ephemeris: Optional[zio.aws.groundstation.model.EphemerisData] =
      Optional.Absent,
    expirationTime: Optional[Timestamp] = Optional.Absent,
    kmsKeyArn: Optional[KeyArn] = Optional.Absent,
    name: SafeName,
    priority: Optional[CustomerEphemerisPriority] = Optional.Absent,
    satelliteId: Uuid,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.CreateEphemerisRequest = {
    import CreateEphemerisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.CreateEphemerisRequest
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(ephemeris.map(value => value.buildAwsValue()))(
        _.ephemeris
      )
      .optionallyWith(
        expirationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationTime)
      .optionallyWith(
        kmsKeyArn.map(value => KeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .name(SafeName.unwrap(name): java.lang.String)
      .optionallyWith(
        priority.map(value => CustomerEphemerisPriority.unwrap(value): Integer)
      )(_.priority)
      .satelliteId(Uuid.unwrap(satelliteId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.CreateEphemerisRequest.ReadOnly =
    zio.aws.groundstation.model.CreateEphemerisRequest.wrap(buildAwsValue())
}
object CreateEphemerisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.CreateEphemerisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.CreateEphemerisRequest =
      zio.aws.groundstation.model.CreateEphemerisRequest(
        enabled.map(value => value),
        ephemeris.map(value => value.asEditable),
        expirationTime.map(value => value),
        kmsKeyArn.map(value => value),
        name,
        priority.map(value => value),
        satelliteId,
        tags.map(value => value)
      )
    def enabled: Optional[Boolean]
    def ephemeris: Optional[zio.aws.groundstation.model.EphemerisData.ReadOnly]
    def expirationTime: Optional[Timestamp]
    def kmsKeyArn: Optional[KeyArn]
    def name: SafeName
    def priority: Optional[CustomerEphemerisPriority]
    def satelliteId: Uuid
    def tags: Optional[Map[String, String]]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getEphemeris: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.EphemerisData.ReadOnly
    ] = AwsError.unwrapOptionField("ephemeris", ephemeris)
    def getExpirationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationTime", expirationTime)
    def getKmsKeyArn: ZIO[Any, AwsError, KeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getName: ZIO[Any, Nothing, SafeName] = ZIO.succeed(name)
    def getPriority: ZIO[Any, AwsError, CustomerEphemerisPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getSatelliteId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(satelliteId)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.CreateEphemerisRequest
  ) extends zio.aws.groundstation.model.CreateEphemerisRequest.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val ephemeris
        : Optional[zio.aws.groundstation.model.EphemerisData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ephemeris())
        .map(value => zio.aws.groundstation.model.EphemerisData.wrap(value))
    override val expirationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationTime())
      .map(value => zio.aws.groundstation.model.primitives.Timestamp(value))
    override val kmsKeyArn: Optional[KeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.groundstation.model.primitives.KeyArn(value))
    override val name: SafeName =
      zio.aws.groundstation.model.primitives.SafeName(impl.name())
    override val priority: Optional[CustomerEphemerisPriority] =
      zio.aws.core.internal
        .optionalFromNullable(impl.priority())
        .map(value =>
          zio.aws.groundstation.model.primitives
            .CustomerEphemerisPriority(value)
        )
    override val satelliteId: Uuid =
      zio.aws.groundstation.model.primitives.Uuid(impl.satelliteId())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.CreateEphemerisRequest
  ): zio.aws.groundstation.model.CreateEphemerisRequest.ReadOnly = new Wrapper(
    impl
  )
}
