package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateMissionProfileResponse(
    missionProfileId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileResponse = {
    import UpdateMissionProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileResponse
      .builder()
      .optionallyWith(missionProfileId.map(value => value: java.lang.String))(
        _.missionProfileId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.UpdateMissionProfileResponse.ReadOnly =
    zio.aws.groundstation.model.UpdateMissionProfileResponse
      .wrap(buildAwsValue())
}
object UpdateMissionProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.UpdateMissionProfileResponse =
      zio.aws.groundstation.model
        .UpdateMissionProfileResponse(missionProfileId.map(value => value))
    def missionProfileId: Optional[String]
    def getMissionProfileId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("missionProfileId", missionProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileResponse
  ) extends zio.aws.groundstation.model.UpdateMissionProfileResponse.ReadOnly {
    override val missionProfileId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.missionProfileId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileResponse
  ): zio.aws.groundstation.model.UpdateMissionProfileResponse.ReadOnly =
    new Wrapper(impl)
}
