package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.SafeName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateConfigRequest(
    configData: zio.aws.groundstation.model.ConfigTypeData,
    configId: String,
    configType: zio.aws.groundstation.model.ConfigCapabilityType,
    name: SafeName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.UpdateConfigRequest = {
    import UpdateConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.UpdateConfigRequest
      .builder()
      .configData(configData.buildAwsValue())
      .configId(configId: java.lang.String)
      .configType(configType.unwrap)
      .name(SafeName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.UpdateConfigRequest.ReadOnly =
    zio.aws.groundstation.model.UpdateConfigRequest.wrap(buildAwsValue())
}
object UpdateConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.UpdateConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.UpdateConfigRequest =
      zio.aws.groundstation.model.UpdateConfigRequest(
        configData.asEditable,
        configId,
        configType,
        name
      )
    def configData: zio.aws.groundstation.model.ConfigTypeData.ReadOnly
    def configId: String
    def configType: zio.aws.groundstation.model.ConfigCapabilityType
    def name: SafeName
    def getConfigData: ZIO[
      Any,
      Nothing,
      zio.aws.groundstation.model.ConfigTypeData.ReadOnly
    ] = ZIO.succeed(configData)
    def getConfigId: ZIO[Any, Nothing, String] = ZIO.succeed(configId)
    def getConfigType
        : ZIO[Any, Nothing, zio.aws.groundstation.model.ConfigCapabilityType] =
      ZIO.succeed(configType)
    def getName: ZIO[Any, Nothing, SafeName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.UpdateConfigRequest
  ) extends zio.aws.groundstation.model.UpdateConfigRequest.ReadOnly {
    override val configData
        : zio.aws.groundstation.model.ConfigTypeData.ReadOnly =
      zio.aws.groundstation.model.ConfigTypeData.wrap(impl.configData())
    override val configId: String = impl.configId(): String
    override val configType: zio.aws.groundstation.model.ConfigCapabilityType =
      zio.aws.groundstation.model.ConfigCapabilityType.wrap(impl.configType())
    override val name: SafeName =
      zio.aws.groundstation.model.primitives.SafeName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.UpdateConfigRequest
  ): zio.aws.groundstation.model.UpdateConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
