package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.MissionProfileArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MissionProfileListItem(
    missionProfileArn: Optional[MissionProfileArn] = Optional.Absent,
    missionProfileId: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    region: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.MissionProfileListItem = {
    import MissionProfileListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.MissionProfileListItem
      .builder()
      .optionallyWith(
        missionProfileArn.map(value =>
          MissionProfileArn.unwrap(value): java.lang.String
        )
      )(_.missionProfileArn)
      .optionallyWith(missionProfileId.map(value => value: java.lang.String))(
        _.missionProfileId
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.MissionProfileListItem.ReadOnly =
    zio.aws.groundstation.model.MissionProfileListItem.wrap(buildAwsValue())
}
object MissionProfileListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.MissionProfileListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.MissionProfileListItem =
      zio.aws.groundstation.model.MissionProfileListItem(
        missionProfileArn.map(value => value),
        missionProfileId.map(value => value),
        name.map(value => value),
        region.map(value => value)
      )
    def missionProfileArn: Optional[MissionProfileArn]
    def missionProfileId: Optional[String]
    def name: Optional[String]
    def region: Optional[String]
    def getMissionProfileArn: ZIO[Any, AwsError, MissionProfileArn] =
      AwsError.unwrapOptionField("missionProfileArn", missionProfileArn)
    def getMissionProfileId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("missionProfileId", missionProfileId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.MissionProfileListItem
  ) extends zio.aws.groundstation.model.MissionProfileListItem.ReadOnly {
    override val missionProfileArn: Optional[MissionProfileArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.missionProfileArn())
        .map(value =>
          zio.aws.groundstation.model.primitives.MissionProfileArn(value)
        )
    override val missionProfileId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.missionProfileId())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val region: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.MissionProfileListItem
  ): zio.aws.groundstation.model.MissionProfileListItem.ReadOnly = new Wrapper(
    impl
  )
}
