package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListGroundStationsResponse(
    groundStationList: Optional[
      Iterable[zio.aws.groundstation.model.GroundStationData]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse = {
    import ListGroundStationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse
      .builder()
      .optionallyWith(
        groundStationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groundStationList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.ListGroundStationsResponse.ReadOnly =
    zio.aws.groundstation.model.ListGroundStationsResponse.wrap(buildAwsValue())
}
object ListGroundStationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ListGroundStationsResponse =
      zio.aws.groundstation.model.ListGroundStationsResponse(
        groundStationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def groundStationList
        : Optional[List[zio.aws.groundstation.model.GroundStationData.ReadOnly]]
    def nextToken: Optional[String]
    def getGroundStationList: ZIO[Any, AwsError, List[
      zio.aws.groundstation.model.GroundStationData.ReadOnly
    ]] = AwsError.unwrapOptionField("groundStationList", groundStationList)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse
  ) extends zio.aws.groundstation.model.ListGroundStationsResponse.ReadOnly {
    override val groundStationList: Optional[
      List[zio.aws.groundstation.model.GroundStationData.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.groundStationList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.groundstation.model.GroundStationData.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse
  ): zio.aws.groundstation.model.ListGroundStationsResponse.ReadOnly =
    new Wrapper(impl)
}
