package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDataflowEndpointGroupsResponse(
    dataflowEndpointGroupList: Optional[
      Iterable[zio.aws.groundstation.model.DataflowEndpointListItem]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsResponse = {
    import ListDataflowEndpointGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsResponse
      .builder()
      .optionallyWith(
        dataflowEndpointGroupList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataflowEndpointGroupList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.ListDataflowEndpointGroupsResponse.ReadOnly =
    zio.aws.groundstation.model.ListDataflowEndpointGroupsResponse
      .wrap(buildAwsValue())
}
object ListDataflowEndpointGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.groundstation.model.ListDataflowEndpointGroupsResponse =
      zio.aws.groundstation.model.ListDataflowEndpointGroupsResponse(
        dataflowEndpointGroupList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def dataflowEndpointGroupList: Optional[
      List[zio.aws.groundstation.model.DataflowEndpointListItem.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getDataflowEndpointGroupList: ZIO[Any, AwsError, List[
      zio.aws.groundstation.model.DataflowEndpointListItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dataflowEndpointGroupList",
      dataflowEndpointGroupList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsResponse
  ) extends zio.aws.groundstation.model.ListDataflowEndpointGroupsResponse.ReadOnly {
    override val dataflowEndpointGroupList: Optional[
      List[zio.aws.groundstation.model.DataflowEndpointListItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataflowEndpointGroupList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.groundstation.model.DataflowEndpointListItem.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsResponse
  ): zio.aws.groundstation.model.ListDataflowEndpointGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
