package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class FrequencyBandwidth(
    units: zio.aws.groundstation.model.BandwidthUnits,
    value: Double
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.FrequencyBandwidth = {
    import FrequencyBandwidth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.FrequencyBandwidth
      .builder()
      .units(units.unwrap)
      .value(value: java.lang.Double)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.FrequencyBandwidth.ReadOnly =
    zio.aws.groundstation.model.FrequencyBandwidth.wrap(buildAwsValue())
}
object FrequencyBandwidth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.FrequencyBandwidth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.FrequencyBandwidth =
      zio.aws.groundstation.model.FrequencyBandwidth(units, value)
    def units: zio.aws.groundstation.model.BandwidthUnits
    def value: Double
    def getUnits
        : ZIO[Any, Nothing, zio.aws.groundstation.model.BandwidthUnits] =
      ZIO.succeed(units)
    def getValue: ZIO[Any, Nothing, Double] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.FrequencyBandwidth
  ) extends zio.aws.groundstation.model.FrequencyBandwidth.ReadOnly {
    override val units: zio.aws.groundstation.model.BandwidthUnits =
      zio.aws.groundstation.model.BandwidthUnits.wrap(impl.units())
    override val value: Double = impl.value(): Double
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.FrequencyBandwidth
  ): zio.aws.groundstation.model.FrequencyBandwidth.ReadOnly = new Wrapper(impl)
}
