package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteDataflowEndpointGroupResponse(
    dataflowEndpointGroupId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DeleteDataflowEndpointGroupResponse = {
    import DeleteDataflowEndpointGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DeleteDataflowEndpointGroupResponse
      .builder()
      .optionallyWith(
        dataflowEndpointGroupId.map(value => value: java.lang.String)
      )(_.dataflowEndpointGroupId)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.DeleteDataflowEndpointGroupResponse.ReadOnly =
    zio.aws.groundstation.model.DeleteDataflowEndpointGroupResponse
      .wrap(buildAwsValue())
}
object DeleteDataflowEndpointGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DeleteDataflowEndpointGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.groundstation.model.DeleteDataflowEndpointGroupResponse =
      zio.aws.groundstation.model.DeleteDataflowEndpointGroupResponse(
        dataflowEndpointGroupId.map(value => value)
      )
    def dataflowEndpointGroupId: Optional[String]
    def getDataflowEndpointGroupId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dataflowEndpointGroupId", dataflowEndpointGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DeleteDataflowEndpointGroupResponse
  ) extends zio.aws.groundstation.model.DeleteDataflowEndpointGroupResponse.ReadOnly {
    override val dataflowEndpointGroupId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataflowEndpointGroupId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DeleteDataflowEndpointGroupResponse
  ): zio.aws.groundstation.model.DeleteDataflowEndpointGroupResponse.ReadOnly =
    new Wrapper(impl)
}
