package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.ConfigArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteConfigResponse(
    configArn: Optional[ConfigArn] = Optional.Absent,
    configId: Optional[String] = Optional.Absent,
    configType: Optional[zio.aws.groundstation.model.ConfigCapabilityType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DeleteConfigResponse = {
    import DeleteConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DeleteConfigResponse
      .builder()
      .optionallyWith(
        configArn.map(value => ConfigArn.unwrap(value): java.lang.String)
      )(_.configArn)
      .optionallyWith(configId.map(value => value: java.lang.String))(
        _.configId
      )
      .optionallyWith(configType.map(value => value.unwrap))(_.configType)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.DeleteConfigResponse.ReadOnly =
    zio.aws.groundstation.model.DeleteConfigResponse.wrap(buildAwsValue())
}
object DeleteConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DeleteConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.DeleteConfigResponse =
      zio.aws.groundstation.model.DeleteConfigResponse(
        configArn.map(value => value),
        configId.map(value => value),
        configType.map(value => value)
      )
    def configArn: Optional[ConfigArn]
    def configId: Optional[String]
    def configType: Optional[zio.aws.groundstation.model.ConfigCapabilityType]
    def getConfigArn: ZIO[Any, AwsError, ConfigArn] =
      AwsError.unwrapOptionField("configArn", configArn)
    def getConfigId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configId", configId)
    def getConfigType
        : ZIO[Any, AwsError, zio.aws.groundstation.model.ConfigCapabilityType] =
      AwsError.unwrapOptionField("configType", configType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DeleteConfigResponse
  ) extends zio.aws.groundstation.model.DeleteConfigResponse.ReadOnly {
    override val configArn: Optional[ConfigArn] = zio.aws.core.internal
      .optionalFromNullable(impl.configArn())
      .map(value => zio.aws.groundstation.model.primitives.ConfigArn(value))
    override val configId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.configId())
      .map(value => value: String)
    override val configType
        : Optional[zio.aws.groundstation.model.ConfigCapabilityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configType())
        .map(value =>
          zio.aws.groundstation.model.ConfigCapabilityType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DeleteConfigResponse
  ): zio.aws.groundstation.model.DeleteConfigResponse.ReadOnly = new Wrapper(
    impl
  )
}
