package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.DataflowEndpointGroupArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataflowEndpointListItem(
    dataflowEndpointGroupArn: Optional[DataflowEndpointGroupArn] =
      Optional.Absent,
    dataflowEndpointGroupId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DataflowEndpointListItem = {
    import DataflowEndpointListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DataflowEndpointListItem
      .builder()
      .optionallyWith(
        dataflowEndpointGroupArn.map(value =>
          DataflowEndpointGroupArn.unwrap(value): java.lang.String
        )
      )(_.dataflowEndpointGroupArn)
      .optionallyWith(
        dataflowEndpointGroupId.map(value => value: java.lang.String)
      )(_.dataflowEndpointGroupId)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.DataflowEndpointListItem.ReadOnly =
    zio.aws.groundstation.model.DataflowEndpointListItem.wrap(buildAwsValue())
}
object DataflowEndpointListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DataflowEndpointListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.DataflowEndpointListItem =
      zio.aws.groundstation.model.DataflowEndpointListItem(
        dataflowEndpointGroupArn.map(value => value),
        dataflowEndpointGroupId.map(value => value)
      )
    def dataflowEndpointGroupArn: Optional[DataflowEndpointGroupArn]
    def dataflowEndpointGroupId: Optional[String]
    def getDataflowEndpointGroupArn
        : ZIO[Any, AwsError, DataflowEndpointGroupArn] = AwsError
      .unwrapOptionField("dataflowEndpointGroupArn", dataflowEndpointGroupArn)
    def getDataflowEndpointGroupId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dataflowEndpointGroupId", dataflowEndpointGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DataflowEndpointListItem
  ) extends zio.aws.groundstation.model.DataflowEndpointListItem.ReadOnly {
    override val dataflowEndpointGroupArn: Optional[DataflowEndpointGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataflowEndpointGroupArn())
        .map(value =>
          zio.aws.groundstation.model.primitives.DataflowEndpointGroupArn(value)
        )
    override val dataflowEndpointGroupId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataflowEndpointGroupId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DataflowEndpointListItem
  ): zio.aws.groundstation.model.DataflowEndpointListItem.ReadOnly =
    new Wrapper(impl)
}
