package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AntennaDownlinkConfig(
    spectrumConfig: zio.aws.groundstation.model.SpectrumConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.AntennaDownlinkConfig = {
    import AntennaDownlinkConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.AntennaDownlinkConfig
      .builder()
      .spectrumConfig(spectrumConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.AntennaDownlinkConfig.ReadOnly =
    zio.aws.groundstation.model.AntennaDownlinkConfig.wrap(buildAwsValue())
}
object AntennaDownlinkConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.AntennaDownlinkConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.AntennaDownlinkConfig =
      zio.aws.groundstation.model
        .AntennaDownlinkConfig(spectrumConfig.asEditable)
    def spectrumConfig: zio.aws.groundstation.model.SpectrumConfig.ReadOnly
    def getSpectrumConfig: ZIO[
      Any,
      Nothing,
      zio.aws.groundstation.model.SpectrumConfig.ReadOnly
    ] = ZIO.succeed(spectrumConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.AntennaDownlinkConfig
  ) extends zio.aws.groundstation.model.AntennaDownlinkConfig.ReadOnly {
    override val spectrumConfig
        : zio.aws.groundstation.model.SpectrumConfig.ReadOnly =
      zio.aws.groundstation.model.SpectrumConfig.wrap(impl.spectrumConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.AntennaDownlinkConfig
  ): zio.aws.groundstation.model.AntennaDownlinkConfig.ReadOnly = new Wrapper(
    impl
  )
}
