package zio.aws.groundstation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.groundstation.model.primitives.{
  SafeName,
  ConfigArn,
  DurationInSeconds
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateMissionProfileRequest(
    contactPostPassDurationSeconds: Optional[DurationInSeconds] =
      Optional.Absent,
    contactPrePassDurationSeconds: Optional[DurationInSeconds] =
      Optional.Absent,
    dataflowEdges: Optional[Iterable[Iterable[ConfigArn]]] = Optional.Absent,
    minimumViableContactDurationSeconds: Optional[DurationInSeconds] =
      Optional.Absent,
    missionProfileId: String,
    name: Optional[SafeName] = Optional.Absent,
    trackingConfigArn: Optional[ConfigArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileRequest = {
    import UpdateMissionProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileRequest
      .builder()
      .optionallyWith(
        contactPostPassDurationSeconds.map(value =>
          DurationInSeconds.unwrap(value): Integer
        )
      )(_.contactPostPassDurationSeconds)
      .optionallyWith(
        contactPrePassDurationSeconds.map(value =>
          DurationInSeconds.unwrap(value): Integer
        )
      )(_.contactPrePassDurationSeconds)
      .optionallyWith(
        dataflowEdges.map(value =>
          value.map { item =>
            item.map { item =>
              ConfigArn.unwrap(item): java.lang.String
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.dataflowEdges)
      .optionallyWith(
        minimumViableContactDurationSeconds.map(value =>
          DurationInSeconds.unwrap(value): Integer
        )
      )(_.minimumViableContactDurationSeconds)
      .missionProfileId(missionProfileId: java.lang.String)
      .optionallyWith(
        name.map(value => SafeName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        trackingConfigArn.map(value =>
          ConfigArn.unwrap(value): java.lang.String
        )
      )(_.trackingConfigArn)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.UpdateMissionProfileRequest.ReadOnly =
    zio.aws.groundstation.model.UpdateMissionProfileRequest
      .wrap(buildAwsValue())
}
object UpdateMissionProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.UpdateMissionProfileRequest =
      zio.aws.groundstation.model.UpdateMissionProfileRequest(
        contactPostPassDurationSeconds.map(value => value),
        contactPrePassDurationSeconds.map(value => value),
        dataflowEdges.map(value => value),
        minimumViableContactDurationSeconds.map(value => value),
        missionProfileId,
        name.map(value => value),
        trackingConfigArn.map(value => value)
      )
    def contactPostPassDurationSeconds: Optional[DurationInSeconds]
    def contactPrePassDurationSeconds: Optional[DurationInSeconds]
    def dataflowEdges: Optional[List[List[ConfigArn]]]
    def minimumViableContactDurationSeconds: Optional[DurationInSeconds]
    def missionProfileId: String
    def name: Optional[SafeName]
    def trackingConfigArn: Optional[ConfigArn]
    def getContactPostPassDurationSeconds
        : ZIO[Any, AwsError, DurationInSeconds] = AwsError.unwrapOptionField(
      "contactPostPassDurationSeconds",
      contactPostPassDurationSeconds
    )
    def getContactPrePassDurationSeconds
        : ZIO[Any, AwsError, DurationInSeconds] = AwsError.unwrapOptionField(
      "contactPrePassDurationSeconds",
      contactPrePassDurationSeconds
    )
    def getDataflowEdges: ZIO[Any, AwsError, List[List[ConfigArn]]] =
      AwsError.unwrapOptionField("dataflowEdges", dataflowEdges)
    def getMinimumViableContactDurationSeconds
        : ZIO[Any, AwsError, DurationInSeconds] = AwsError.unwrapOptionField(
      "minimumViableContactDurationSeconds",
      minimumViableContactDurationSeconds
    )
    def getMissionProfileId: ZIO[Any, Nothing, String] =
      ZIO.succeed(missionProfileId)
    def getName: ZIO[Any, AwsError, SafeName] =
      AwsError.unwrapOptionField("name", name)
    def getTrackingConfigArn: ZIO[Any, AwsError, ConfigArn] =
      AwsError.unwrapOptionField("trackingConfigArn", trackingConfigArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileRequest
  ) extends zio.aws.groundstation.model.UpdateMissionProfileRequest.ReadOnly {
    override val contactPostPassDurationSeconds: Optional[DurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactPostPassDurationSeconds())
        .map(value =>
          zio.aws.groundstation.model.primitives.DurationInSeconds(value)
        )
    override val contactPrePassDurationSeconds: Optional[DurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactPrePassDurationSeconds())
        .map(value =>
          zio.aws.groundstation.model.primitives.DurationInSeconds(value)
        )
    override val dataflowEdges: Optional[List[List[ConfigArn]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataflowEdges())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              zio.aws.groundstation.model.primitives.ConfigArn(item)
            }.toList
          }.toList
        )
    override val minimumViableContactDurationSeconds
        : Optional[DurationInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.minimumViableContactDurationSeconds())
      .map(value =>
        zio.aws.groundstation.model.primitives.DurationInSeconds(value)
      )
    override val missionProfileId: String = impl.missionProfileId(): String
    override val name: Optional[SafeName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.groundstation.model.primitives.SafeName(value))
    override val trackingConfigArn: Optional[ConfigArn] = zio.aws.core.internal
      .optionalFromNullable(impl.trackingConfigArn())
      .map(value => zio.aws.groundstation.model.primitives.ConfigArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileRequest
  ): zio.aws.groundstation.model.UpdateMissionProfileRequest.ReadOnly =
    new Wrapper(impl)
}
