package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Source(
    configDetails: Optional[zio.aws.groundstation.model.ConfigDetails] =
      Optional.Absent,
    configId: Optional[String] = Optional.Absent,
    configType: Optional[zio.aws.groundstation.model.ConfigCapabilityType] =
      Optional.Absent,
    dataflowSourceRegion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.Source = {
    import Source.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.Source
      .builder()
      .optionallyWith(configDetails.map(value => value.buildAwsValue()))(
        _.configDetails
      )
      .optionallyWith(configId.map(value => value: java.lang.String))(
        _.configId
      )
      .optionallyWith(configType.map(value => value.unwrap))(_.configType)
      .optionallyWith(
        dataflowSourceRegion.map(value => value: java.lang.String)
      )(_.dataflowSourceRegion)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.Source.ReadOnly =
    zio.aws.groundstation.model.Source.wrap(buildAwsValue())
}
object Source {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.Source
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.Source =
      zio.aws.groundstation.model.Source(
        configDetails.map(value => value.asEditable),
        configId.map(value => value),
        configType.map(value => value),
        dataflowSourceRegion.map(value => value)
      )
    def configDetails
        : Optional[zio.aws.groundstation.model.ConfigDetails.ReadOnly]
    def configId: Optional[String]
    def configType: Optional[zio.aws.groundstation.model.ConfigCapabilityType]
    def dataflowSourceRegion: Optional[String]
    def getConfigDetails: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.ConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("configDetails", configDetails)
    def getConfigId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configId", configId)
    def getConfigType
        : ZIO[Any, AwsError, zio.aws.groundstation.model.ConfigCapabilityType] =
      AwsError.unwrapOptionField("configType", configType)
    def getDataflowSourceRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataflowSourceRegion", dataflowSourceRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.Source
  ) extends zio.aws.groundstation.model.Source.ReadOnly {
    override val configDetails
        : Optional[zio.aws.groundstation.model.ConfigDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configDetails())
        .map(value => zio.aws.groundstation.model.ConfigDetails.wrap(value))
    override val configId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.configId())
      .map(value => value: String)
    override val configType
        : Optional[zio.aws.groundstation.model.ConfigCapabilityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configType())
        .map(value =>
          zio.aws.groundstation.model.ConfigCapabilityType.wrap(value)
        )
    override val dataflowSourceRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataflowSourceRegion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.Source
  ): zio.aws.groundstation.model.Source.ReadOnly = new Wrapper(impl)
}
