package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataflowDetail(
    destination: Optional[zio.aws.groundstation.model.Destination] =
      Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent,
    source: Optional[zio.aws.groundstation.model.Source] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DataflowDetail = {
    import DataflowDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DataflowDetail
      .builder()
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.DataflowDetail.ReadOnly =
    zio.aws.groundstation.model.DataflowDetail.wrap(buildAwsValue())
}
object DataflowDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DataflowDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.DataflowDetail =
      zio.aws.groundstation.model.DataflowDetail(
        destination.map(value => value.asEditable),
        errorMessage.map(value => value),
        source.map(value => value.asEditable)
      )
    def destination: Optional[zio.aws.groundstation.model.Destination.ReadOnly]
    def errorMessage: Optional[String]
    def source: Optional[zio.aws.groundstation.model.Source.ReadOnly]
    def getDestination
        : ZIO[Any, AwsError, zio.aws.groundstation.model.Destination.ReadOnly] =
      AwsError.unwrapOptionField("destination", destination)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getSource
        : ZIO[Any, AwsError, zio.aws.groundstation.model.Source.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DataflowDetail
  ) extends zio.aws.groundstation.model.DataflowDetail.ReadOnly {
    override val destination
        : Optional[zio.aws.groundstation.model.Destination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value => zio.aws.groundstation.model.Destination.wrap(value))
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
    override val source: Optional[zio.aws.groundstation.model.Source.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.groundstation.model.Source.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DataflowDetail
  ): zio.aws.groundstation.model.DataflowDetail.ReadOnly = new Wrapper(impl)
}
