package zio.aws.groundstation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.groundstation.model.primitives.{
  SafeName,
  ConfigArn,
  DurationInSeconds
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateMissionProfileRequest(
    contactPostPassDurationSeconds: Optional[DurationInSeconds] =
      Optional.Absent,
    contactPrePassDurationSeconds: Optional[DurationInSeconds] =
      Optional.Absent,
    dataflowEdges: Iterable[Iterable[ConfigArn]],
    minimumViableContactDurationSeconds: DurationInSeconds,
    name: SafeName,
    tags: Optional[Map[String, String]] = Optional.Absent,
    trackingConfigArn: ConfigArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.CreateMissionProfileRequest = {
    import CreateMissionProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.CreateMissionProfileRequest
      .builder()
      .optionallyWith(
        contactPostPassDurationSeconds.map(value =>
          DurationInSeconds.unwrap(value): Integer
        )
      )(_.contactPostPassDurationSeconds)
      .optionallyWith(
        contactPrePassDurationSeconds.map(value =>
          DurationInSeconds.unwrap(value): Integer
        )
      )(_.contactPrePassDurationSeconds)
      .dataflowEdges(dataflowEdges.map { item =>
        item.map { item =>
          ConfigArn.unwrap(item): java.lang.String
        }.asJavaCollection
      }.asJavaCollection)
      .minimumViableContactDurationSeconds(
        DurationInSeconds.unwrap(minimumViableContactDurationSeconds): Integer
      )
      .name(SafeName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .trackingConfigArn(ConfigArn.unwrap(trackingConfigArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.CreateMissionProfileRequest.ReadOnly =
    zio.aws.groundstation.model.CreateMissionProfileRequest
      .wrap(buildAwsValue())
}
object CreateMissionProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.CreateMissionProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.CreateMissionProfileRequest =
      zio.aws.groundstation.model.CreateMissionProfileRequest(
        contactPostPassDurationSeconds.map(value => value),
        contactPrePassDurationSeconds.map(value => value),
        dataflowEdges,
        minimumViableContactDurationSeconds,
        name,
        tags.map(value => value),
        trackingConfigArn
      )
    def contactPostPassDurationSeconds: Optional[DurationInSeconds]
    def contactPrePassDurationSeconds: Optional[DurationInSeconds]
    def dataflowEdges: List[List[ConfigArn]]
    def minimumViableContactDurationSeconds: DurationInSeconds
    def name: SafeName
    def tags: Optional[Map[String, String]]
    def trackingConfigArn: ConfigArn
    def getContactPostPassDurationSeconds
        : ZIO[Any, AwsError, DurationInSeconds] = AwsError.unwrapOptionField(
      "contactPostPassDurationSeconds",
      contactPostPassDurationSeconds
    )
    def getContactPrePassDurationSeconds
        : ZIO[Any, AwsError, DurationInSeconds] = AwsError.unwrapOptionField(
      "contactPrePassDurationSeconds",
      contactPrePassDurationSeconds
    )
    def getDataflowEdges: ZIO[Any, Nothing, List[List[ConfigArn]]] =
      ZIO.succeed(dataflowEdges)
    def getMinimumViableContactDurationSeconds
        : ZIO[Any, Nothing, DurationInSeconds] =
      ZIO.succeed(minimumViableContactDurationSeconds)
    def getName: ZIO[Any, Nothing, SafeName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTrackingConfigArn: ZIO[Any, Nothing, ConfigArn] =
      ZIO.succeed(trackingConfigArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.CreateMissionProfileRequest
  ) extends zio.aws.groundstation.model.CreateMissionProfileRequest.ReadOnly {
    override val contactPostPassDurationSeconds: Optional[DurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactPostPassDurationSeconds())
        .map(value =>
          zio.aws.groundstation.model.primitives.DurationInSeconds(value)
        )
    override val contactPrePassDurationSeconds: Optional[DurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactPrePassDurationSeconds())
        .map(value =>
          zio.aws.groundstation.model.primitives.DurationInSeconds(value)
        )
    override val dataflowEdges: List[List[ConfigArn]] = impl
      .dataflowEdges()
      .asScala
      .map { item =>
        item.asScala.map { item =>
          zio.aws.groundstation.model.primitives.ConfigArn(item)
        }.toList
      }
      .toList
    override val minimumViableContactDurationSeconds: DurationInSeconds =
      zio.aws.groundstation.model.primitives
        .DurationInSeconds(impl.minimumViableContactDurationSeconds())
    override val name: SafeName =
      zio.aws.groundstation.model.primitives.SafeName(impl.name())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val trackingConfigArn: ConfigArn =
      zio.aws.groundstation.model.primitives.ConfigArn(impl.trackingConfigArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.CreateMissionProfileRequest
  ): zio.aws.groundstation.model.CreateMissionProfileRequest.ReadOnly =
    new Wrapper(impl)
}
