package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConfigDetails(
    antennaDemodDecodeDetails: Optional[
      zio.aws.groundstation.model.AntennaDemodDecodeDetails
    ] = Optional.Absent,
    endpointDetails: Optional[zio.aws.groundstation.model.EndpointDetails] =
      Optional.Absent,
    s3RecordingDetails: Optional[
      zio.aws.groundstation.model.S3RecordingDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ConfigDetails = {
    import ConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ConfigDetails
      .builder()
      .optionallyWith(
        antennaDemodDecodeDetails.map(value => value.buildAwsValue())
      )(_.antennaDemodDecodeDetails)
      .optionallyWith(endpointDetails.map(value => value.buildAwsValue()))(
        _.endpointDetails
      )
      .optionallyWith(s3RecordingDetails.map(value => value.buildAwsValue()))(
        _.s3RecordingDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ConfigDetails.ReadOnly =
    zio.aws.groundstation.model.ConfigDetails.wrap(buildAwsValue())
}
object ConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ConfigDetails =
      zio.aws.groundstation.model.ConfigDetails(
        antennaDemodDecodeDetails.map(value => value.asEditable),
        endpointDetails.map(value => value.asEditable),
        s3RecordingDetails.map(value => value.asEditable)
      )
    def antennaDemodDecodeDetails: Optional[
      zio.aws.groundstation.model.AntennaDemodDecodeDetails.ReadOnly
    ]
    def endpointDetails
        : Optional[zio.aws.groundstation.model.EndpointDetails.ReadOnly]
    def s3RecordingDetails
        : Optional[zio.aws.groundstation.model.S3RecordingDetails.ReadOnly]
    def getAntennaDemodDecodeDetails: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.AntennaDemodDecodeDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "antennaDemodDecodeDetails",
      antennaDemodDecodeDetails
    )
    def getEndpointDetails: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.EndpointDetails.ReadOnly
    ] = AwsError.unwrapOptionField("endpointDetails", endpointDetails)
    def getS3RecordingDetails: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.S3RecordingDetails.ReadOnly
    ] = AwsError.unwrapOptionField("s3RecordingDetails", s3RecordingDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ConfigDetails
  ) extends zio.aws.groundstation.model.ConfigDetails.ReadOnly {
    override val antennaDemodDecodeDetails: Optional[
      zio.aws.groundstation.model.AntennaDemodDecodeDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.antennaDemodDecodeDetails())
      .map(value =>
        zio.aws.groundstation.model.AntennaDemodDecodeDetails.wrap(value)
      )
    override val endpointDetails
        : Optional[zio.aws.groundstation.model.EndpointDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointDetails())
        .map(value => zio.aws.groundstation.model.EndpointDetails.wrap(value))
    override val s3RecordingDetails
        : Optional[zio.aws.groundstation.model.S3RecordingDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3RecordingDetails())
        .map(value =>
          zio.aws.groundstation.model.S3RecordingDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ConfigDetails
  ): zio.aws.groundstation.model.ConfigDetails.ReadOnly = new Wrapper(impl)
}
