package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CancelContactResponse(
    contactId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.CancelContactResponse = {
    import CancelContactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.CancelContactResponse
      .builder()
      .optionallyWith(contactId.map(value => value: java.lang.String))(
        _.contactId
      )
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.CancelContactResponse.ReadOnly =
    zio.aws.groundstation.model.CancelContactResponse.wrap(buildAwsValue())
}
object CancelContactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.CancelContactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.CancelContactResponse =
      zio.aws.groundstation.model
        .CancelContactResponse(contactId.map(value => value))
    def contactId: Optional[String]
    def getContactId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contactId", contactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.CancelContactResponse
  ) extends zio.aws.groundstation.model.CancelContactResponse.ReadOnly {
    override val contactId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.contactId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.CancelContactResponse
  ): zio.aws.groundstation.model.CancelContactResponse.ReadOnly = new Wrapper(
    impl
  )
}
