package zio.aws.groundstation.model
import scala.jdk.CollectionConverters.*
sealed trait BandwidthUnits {
  def unwrap: software.amazon.awssdk.services.groundstation.model.BandwidthUnits
}
object BandwidthUnits {
  def wrap(
      value: software.amazon.awssdk.services.groundstation.model.BandwidthUnits
  ): zio.aws.groundstation.model.BandwidthUnits = value match {
    case software.amazon.awssdk.services.groundstation.model.BandwidthUnits.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.groundstation.model.BandwidthUnits.G_HZ =>
      val r = GHz
      r
    case software.amazon.awssdk.services.groundstation.model.BandwidthUnits.M_HZ =>
      val r = MHz
      r
    case software.amazon.awssdk.services.groundstation.model.BandwidthUnits.K_HZ =>
      val r = kHz
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.groundstation.model.BandwidthUnits {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.BandwidthUnits =
      software.amazon.awssdk.services.groundstation.model.BandwidthUnits.UNKNOWN_TO_SDK_VERSION
  }
  case object GHz extends zio.aws.groundstation.model.BandwidthUnits {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.BandwidthUnits =
      software.amazon.awssdk.services.groundstation.model.BandwidthUnits.G_HZ
  }
  case object MHz extends zio.aws.groundstation.model.BandwidthUnits {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.BandwidthUnits =
      software.amazon.awssdk.services.groundstation.model.BandwidthUnits.M_HZ
  }
  case object kHz extends zio.aws.groundstation.model.BandwidthUnits {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.BandwidthUnits =
      software.amazon.awssdk.services.groundstation.model.BandwidthUnits.K_HZ
  }
}
