package zio.aws.groundstation
import zio.aws.groundstation.model.ConfigListItem.ReadOnly
import software.amazon.awssdk.services.groundstation.{
  GroundStationAsyncClientBuilder,
  GroundStationAsyncClient
}
import zio.aws.core.config.AwsConfig
import zio.aws.groundstation.model.{
  CreateDataflowEndpointGroupRequest,
  ListMissionProfilesRequest,
  UpdateConfigRequest,
  ListConfigsRequest,
  UpdateMissionProfileRequest,
  GetMissionProfileRequest,
  ListDataflowEndpointGroupsRequest,
  ListTagsForResourceRequest,
  CancelContactRequest,
  DeleteDataflowEndpointGroupRequest,
  GetDataflowEndpointGroupRequest,
  CreateMissionProfileRequest,
  ListGroundStationsRequest,
  DeleteMissionProfileRequest,
  GetMinuteUsageRequest,
  CreateConfigRequest,
  DescribeContactRequest,
  GetSatelliteRequest,
  GetConfigRequest,
  UntagResourceRequest,
  ListContactsRequest,
  DeleteConfigRequest,
  ListSatellitesRequest,
  TagResourceRequest,
  ReserveContactRequest
}
import software.amazon.awssdk.services.groundstation.paginators.{
  ListMissionProfilesPublisher,
  ListContactsPublisher,
  ListSatellitesPublisher,
  ListDataflowEndpointGroupsPublisher,
  ListGroundStationsPublisher,
  ListConfigsPublisher
}
import software.amazon.awssdk.services.groundstation.model.{
  DeleteConfigResponse,
  MissionProfileListItem,
  ListMissionProfilesResponse,
  CreateMissionProfileResponse,
  ListContactsResponse,
  GetMinuteUsageResponse,
  DeleteMissionProfileResponse,
  DeleteDataflowEndpointGroupResponse,
  UpdateMissionProfileResponse,
  UpdateConfigResponse,
  DescribeContactResponse,
  ListSatellitesResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  GetDataflowEndpointGroupResponse,
  CancelContactResponse,
  ListConfigsResponse,
  ContactData,
  ListDataflowEndpointGroupsResponse,
  DataflowEndpointListItem,
  CreateConfigResponse,
  ReserveContactResponse,
  GroundStationData,
  CreateDataflowEndpointGroupResponse,
  SatelliteListItem,
  GetSatelliteResponse,
  ConfigListItem,
  GetMissionProfileResponse,
  TagResourceResponse,
  GetConfigResponse,
  ListGroundStationsResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait GroundStation extends AspectSupport[GroundStation] {
  val api: GroundStationAsyncClient
  def createConfig(
      request: CreateConfigRequest
  ): IO[AwsError, zio.aws.groundstation.model.CreateConfigResponse.ReadOnly]
  def listConfigs(request: ListConfigsRequest): ZStream[Any, AwsError, ReadOnly]
  def listConfigsPaginated(
      request: ListConfigsRequest
  ): IO[AwsError, zio.aws.groundstation.model.ListConfigsResponse.ReadOnly]
  def deleteConfig(
      request: DeleteConfigRequest
  ): IO[AwsError, zio.aws.groundstation.model.DeleteConfigResponse.ReadOnly]
  def cancelContact(
      request: CancelContactRequest
  ): IO[AwsError, zio.aws.groundstation.model.CancelContactResponse.ReadOnly]
  def getMinuteUsage(
      request: GetMinuteUsageRequest
  ): IO[AwsError, zio.aws.groundstation.model.GetMinuteUsageResponse.ReadOnly]
  def listMissionProfiles(request: ListMissionProfilesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.groundstation.model.MissionProfileListItem.ReadOnly
  ]
  def listMissionProfilesPaginated(request: ListMissionProfilesRequest): IO[
    AwsError,
    zio.aws.groundstation.model.ListMissionProfilesResponse.ReadOnly
  ]
  def getDataflowEndpointGroup(request: GetDataflowEndpointGroupRequest): IO[
    AwsError,
    zio.aws.groundstation.model.GetDataflowEndpointGroupResponse.ReadOnly
  ]
  def createDataflowEndpointGroup(
      request: CreateDataflowEndpointGroupRequest
  ): IO[
    AwsError,
    zio.aws.groundstation.model.CreateDataflowEndpointGroupResponse.ReadOnly
  ]
  def updateMissionProfile(request: UpdateMissionProfileRequest): IO[
    AwsError,
    zio.aws.groundstation.model.UpdateMissionProfileResponse.ReadOnly
  ]
  def getConfig(
      request: GetConfigRequest
  ): IO[AwsError, zio.aws.groundstation.model.GetConfigResponse.ReadOnly]
  def listSatellites(request: ListSatellitesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.groundstation.model.SatelliteListItem.ReadOnly
  ]
  def listSatellitesPaginated(
      request: ListSatellitesRequest
  ): IO[AwsError, zio.aws.groundstation.model.ListSatellitesResponse.ReadOnly]
  def getSatellite(
      request: GetSatelliteRequest
  ): IO[AwsError, zio.aws.groundstation.model.GetSatelliteResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.groundstation.model.UntagResourceResponse.ReadOnly]
  def describeContact(
      request: DescribeContactRequest
  ): IO[AwsError, zio.aws.groundstation.model.DescribeContactResponse.ReadOnly]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.groundstation.model.ListTagsForResourceResponse.ReadOnly
  ]
  def deleteMissionProfile(request: DeleteMissionProfileRequest): IO[
    AwsError,
    zio.aws.groundstation.model.DeleteMissionProfileResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.groundstation.model.TagResourceResponse.ReadOnly]
  def getMissionProfile(request: GetMissionProfileRequest): IO[
    AwsError,
    zio.aws.groundstation.model.GetMissionProfileResponse.ReadOnly
  ]
  def listContacts(
      request: ListContactsRequest
  ): ZStream[Any, AwsError, zio.aws.groundstation.model.ContactData.ReadOnly]
  def listContactsPaginated(
      request: ListContactsRequest
  ): IO[AwsError, zio.aws.groundstation.model.ListContactsResponse.ReadOnly]
  def deleteDataflowEndpointGroup(
      request: DeleteDataflowEndpointGroupRequest
  ): IO[
    AwsError,
    zio.aws.groundstation.model.DeleteDataflowEndpointGroupResponse.ReadOnly
  ]
  def reserveContact(
      request: ReserveContactRequest
  ): IO[AwsError, zio.aws.groundstation.model.ReserveContactResponse.ReadOnly]
  def createMissionProfile(request: CreateMissionProfileRequest): IO[
    AwsError,
    zio.aws.groundstation.model.CreateMissionProfileResponse.ReadOnly
  ]
  def updateConfig(
      request: UpdateConfigRequest
  ): IO[AwsError, zio.aws.groundstation.model.UpdateConfigResponse.ReadOnly]
  def listGroundStations(request: ListGroundStationsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.groundstation.model.GroundStationData.ReadOnly
  ]
  def listGroundStationsPaginated(request: ListGroundStationsRequest): IO[
    AwsError,
    zio.aws.groundstation.model.ListGroundStationsResponse.ReadOnly
  ]
  def listDataflowEndpointGroups(
      request: ListDataflowEndpointGroupsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.groundstation.model.DataflowEndpointListItem.ReadOnly
  ]
  def listDataflowEndpointGroupsPaginated(
      request: ListDataflowEndpointGroupsRequest
  ): IO[
    AwsError,
    zio.aws.groundstation.model.ListDataflowEndpointGroupsResponse.ReadOnly
  ]
}
object GroundStation {
  val live: ZLayer[AwsConfig, java.lang.Throwable, GroundStation] = customized(
    identity
  )
  def customized(
      customization: GroundStationAsyncClientBuilder => GroundStationAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, GroundStation] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: GroundStationAsyncClientBuilder => GroundStationAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, GroundStation] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = GroundStationAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[GroundStationAsyncClient, GroundStationAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      GroundStationAsyncClient,
      GroundStationAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new GroundStationImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class GroundStationImpl[R](
      override val api: GroundStationAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends GroundStation
      with AwsServiceBase[R] {
    override val serviceName: String = "GroundStation"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): GroundStationImpl[R1] = new GroundStationImpl(api, newAspect, r)
    def createConfig(
        request: CreateConfigRequest
    ): IO[AwsError, zio.aws.groundstation.model.CreateConfigResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.groundstation.model.CreateConfigRequest,
        CreateConfigResponse
      ]("createConfig", api.createConfig)(request.buildAwsValue())
        .map(zio.aws.groundstation.model.CreateConfigResponse.wrap)
        .provideEnvironment(r)
    def listConfigs(
        request: ListConfigsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.groundstation.model.ListConfigsRequest,
      ConfigListItem,
      ListConfigsPublisher
    ]("listConfigs", api.listConfigsPaginator, _.configList())(
      request.buildAwsValue()
    ).map(item => zio.aws.groundstation.model.ConfigListItem.wrap(item))
      .provideEnvironment(r)
    def listConfigsPaginated(
        request: ListConfigsRequest
    ): IO[AwsError, zio.aws.groundstation.model.ListConfigsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.groundstation.model.ListConfigsRequest,
        ListConfigsResponse
      ]("listConfigs", api.listConfigs)(request.buildAwsValue())
        .map(zio.aws.groundstation.model.ListConfigsResponse.wrap)
        .provideEnvironment(r)
    def deleteConfig(
        request: DeleteConfigRequest
    ): IO[AwsError, zio.aws.groundstation.model.DeleteConfigResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.groundstation.model.DeleteConfigRequest,
        DeleteConfigResponse
      ]("deleteConfig", api.deleteConfig)(request.buildAwsValue())
        .map(zio.aws.groundstation.model.DeleteConfigResponse.wrap)
        .provideEnvironment(r)
    def cancelContact(request: CancelContactRequest): IO[
      AwsError,
      zio.aws.groundstation.model.CancelContactResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.groundstation.model.CancelContactRequest,
      CancelContactResponse
    ]("cancelContact", api.cancelContact)(request.buildAwsValue())
      .map(zio.aws.groundstation.model.CancelContactResponse.wrap)
      .provideEnvironment(r)
    def getMinuteUsage(request: GetMinuteUsageRequest): IO[
      AwsError,
      zio.aws.groundstation.model.GetMinuteUsageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.groundstation.model.GetMinuteUsageRequest,
      GetMinuteUsageResponse
    ]("getMinuteUsage", api.getMinuteUsage)(request.buildAwsValue())
      .map(zio.aws.groundstation.model.GetMinuteUsageResponse.wrap)
      .provideEnvironment(r)
    def listMissionProfiles(request: ListMissionProfilesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.groundstation.model.MissionProfileListItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.groundstation.model.ListMissionProfilesRequest,
      MissionProfileListItem,
      ListMissionProfilesPublisher
    ](
      "listMissionProfiles",
      api.listMissionProfilesPaginator,
      _.missionProfileList()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.groundstation.model.MissionProfileListItem.wrap(item)
      )
      .provideEnvironment(r)
    def listMissionProfilesPaginated(request: ListMissionProfilesRequest): IO[
      AwsError,
      zio.aws.groundstation.model.ListMissionProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.groundstation.model.ListMissionProfilesRequest,
      ListMissionProfilesResponse
    ]("listMissionProfiles", api.listMissionProfiles)(request.buildAwsValue())
      .map(zio.aws.groundstation.model.ListMissionProfilesResponse.wrap)
      .provideEnvironment(r)
    def getDataflowEndpointGroup(request: GetDataflowEndpointGroupRequest): IO[
      AwsError,
      zio.aws.groundstation.model.GetDataflowEndpointGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupRequest,
      GetDataflowEndpointGroupResponse
    ]("getDataflowEndpointGroup", api.getDataflowEndpointGroup)(
      request.buildAwsValue()
    ).map(zio.aws.groundstation.model.GetDataflowEndpointGroupResponse.wrap)
      .provideEnvironment(r)
    def createDataflowEndpointGroup(
        request: CreateDataflowEndpointGroupRequest
    ): IO[
      AwsError,
      zio.aws.groundstation.model.CreateDataflowEndpointGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupRequest,
      CreateDataflowEndpointGroupResponse
    ]("createDataflowEndpointGroup", api.createDataflowEndpointGroup)(
      request.buildAwsValue()
    ).map(zio.aws.groundstation.model.CreateDataflowEndpointGroupResponse.wrap)
      .provideEnvironment(r)
    def updateMissionProfile(request: UpdateMissionProfileRequest): IO[
      AwsError,
      zio.aws.groundstation.model.UpdateMissionProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileRequest,
      UpdateMissionProfileResponse
    ]("updateMissionProfile", api.updateMissionProfile)(request.buildAwsValue())
      .map(zio.aws.groundstation.model.UpdateMissionProfileResponse.wrap)
      .provideEnvironment(r)
    def getConfig(
        request: GetConfigRequest
    ): IO[AwsError, zio.aws.groundstation.model.GetConfigResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.groundstation.model.GetConfigRequest,
        GetConfigResponse
      ]("getConfig", api.getConfig)(request.buildAwsValue())
        .map(zio.aws.groundstation.model.GetConfigResponse.wrap)
        .provideEnvironment(r)
    def listSatellites(request: ListSatellitesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.groundstation.model.SatelliteListItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.groundstation.model.ListSatellitesRequest,
      SatelliteListItem,
      ListSatellitesPublisher
    ]("listSatellites", api.listSatellitesPaginator, _.satellites())(
      request.buildAwsValue()
    ).map(item => zio.aws.groundstation.model.SatelliteListItem.wrap(item))
      .provideEnvironment(r)
    def listSatellitesPaginated(request: ListSatellitesRequest): IO[
      AwsError,
      zio.aws.groundstation.model.ListSatellitesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.groundstation.model.ListSatellitesRequest,
      ListSatellitesResponse
    ]("listSatellites", api.listSatellites)(request.buildAwsValue())
      .map(zio.aws.groundstation.model.ListSatellitesResponse.wrap)
      .provideEnvironment(r)
    def getSatellite(
        request: GetSatelliteRequest
    ): IO[AwsError, zio.aws.groundstation.model.GetSatelliteResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.groundstation.model.GetSatelliteRequest,
        GetSatelliteResponse
      ]("getSatellite", api.getSatellite)(request.buildAwsValue())
        .map(zio.aws.groundstation.model.GetSatelliteResponse.wrap)
        .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.groundstation.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.groundstation.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.groundstation.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def describeContact(request: DescribeContactRequest): IO[
      AwsError,
      zio.aws.groundstation.model.DescribeContactResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.groundstation.model.DescribeContactRequest,
      DescribeContactResponse
    ]("describeContact", api.describeContact)(request.buildAwsValue())
      .map(zio.aws.groundstation.model.DescribeContactResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.groundstation.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.groundstation.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.groundstation.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteMissionProfile(request: DeleteMissionProfileRequest): IO[
      AwsError,
      zio.aws.groundstation.model.DeleteMissionProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileRequest,
      DeleteMissionProfileResponse
    ]("deleteMissionProfile", api.deleteMissionProfile)(request.buildAwsValue())
      .map(zio.aws.groundstation.model.DeleteMissionProfileResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.groundstation.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.groundstation.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.groundstation.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def getMissionProfile(request: GetMissionProfileRequest): IO[
      AwsError,
      zio.aws.groundstation.model.GetMissionProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.groundstation.model.GetMissionProfileRequest,
      GetMissionProfileResponse
    ]("getMissionProfile", api.getMissionProfile)(request.buildAwsValue())
      .map(zio.aws.groundstation.model.GetMissionProfileResponse.wrap)
      .provideEnvironment(r)
    def listContacts(request: ListContactsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.groundstation.model.ContactData.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.groundstation.model.ListContactsRequest,
      ContactData,
      ListContactsPublisher
    ]("listContacts", api.listContactsPaginator, _.contactList())(
      request.buildAwsValue()
    ).map(item => zio.aws.groundstation.model.ContactData.wrap(item))
      .provideEnvironment(r)
    def listContactsPaginated(
        request: ListContactsRequest
    ): IO[AwsError, zio.aws.groundstation.model.ListContactsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.groundstation.model.ListContactsRequest,
        ListContactsResponse
      ]("listContacts", api.listContacts)(request.buildAwsValue())
        .map(zio.aws.groundstation.model.ListContactsResponse.wrap)
        .provideEnvironment(r)
    def deleteDataflowEndpointGroup(
        request: DeleteDataflowEndpointGroupRequest
    ): IO[
      AwsError,
      zio.aws.groundstation.model.DeleteDataflowEndpointGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.groundstation.model.DeleteDataflowEndpointGroupRequest,
      DeleteDataflowEndpointGroupResponse
    ]("deleteDataflowEndpointGroup", api.deleteDataflowEndpointGroup)(
      request.buildAwsValue()
    ).map(zio.aws.groundstation.model.DeleteDataflowEndpointGroupResponse.wrap)
      .provideEnvironment(r)
    def reserveContact(request: ReserveContactRequest): IO[
      AwsError,
      zio.aws.groundstation.model.ReserveContactResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.groundstation.model.ReserveContactRequest,
      ReserveContactResponse
    ]("reserveContact", api.reserveContact)(request.buildAwsValue())
      .map(zio.aws.groundstation.model.ReserveContactResponse.wrap)
      .provideEnvironment(r)
    def createMissionProfile(request: CreateMissionProfileRequest): IO[
      AwsError,
      zio.aws.groundstation.model.CreateMissionProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.groundstation.model.CreateMissionProfileRequest,
      CreateMissionProfileResponse
    ]("createMissionProfile", api.createMissionProfile)(request.buildAwsValue())
      .map(zio.aws.groundstation.model.CreateMissionProfileResponse.wrap)
      .provideEnvironment(r)
    def updateConfig(
        request: UpdateConfigRequest
    ): IO[AwsError, zio.aws.groundstation.model.UpdateConfigResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.groundstation.model.UpdateConfigRequest,
        UpdateConfigResponse
      ]("updateConfig", api.updateConfig)(request.buildAwsValue())
        .map(zio.aws.groundstation.model.UpdateConfigResponse.wrap)
        .provideEnvironment(r)
    def listGroundStations(request: ListGroundStationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.groundstation.model.GroundStationData.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest,
      GroundStationData,
      ListGroundStationsPublisher
    ](
      "listGroundStations",
      api.listGroundStationsPaginator,
      _.groundStationList()
    )(request.buildAwsValue())
      .map(item => zio.aws.groundstation.model.GroundStationData.wrap(item))
      .provideEnvironment(r)
    def listGroundStationsPaginated(request: ListGroundStationsRequest): IO[
      AwsError,
      zio.aws.groundstation.model.ListGroundStationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest,
      ListGroundStationsResponse
    ]("listGroundStations", api.listGroundStations)(request.buildAwsValue())
      .map(zio.aws.groundstation.model.ListGroundStationsResponse.wrap)
      .provideEnvironment(r)
    def listDataflowEndpointGroups(
        request: ListDataflowEndpointGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.groundstation.model.DataflowEndpointListItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest,
      DataflowEndpointListItem,
      ListDataflowEndpointGroupsPublisher
    ](
      "listDataflowEndpointGroups",
      api.listDataflowEndpointGroupsPaginator,
      _.dataflowEndpointGroupList()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.groundstation.model.DataflowEndpointListItem.wrap(item)
      )
      .provideEnvironment(r)
    def listDataflowEndpointGroupsPaginated(
        request: ListDataflowEndpointGroupsRequest
    ): IO[
      AwsError,
      zio.aws.groundstation.model.ListDataflowEndpointGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest,
      ListDataflowEndpointGroupsResponse
    ]("listDataflowEndpointGroups", api.listDataflowEndpointGroups)(
      request.buildAwsValue()
    ).map(zio.aws.groundstation.model.ListDataflowEndpointGroupsResponse.wrap)
      .provideEnvironment(r)
  }
  def createConfig(request: CreateConfigRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.CreateConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConfig(request))
  def listConfigs(
      request: ListConfigsRequest
  ): ZStream[zio.aws.groundstation.GroundStation, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listConfigs(request))
  def listConfigsPaginated(request: ListConfigsRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.ListConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listConfigsPaginated(request))
  def deleteConfig(request: DeleteConfigRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.DeleteConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConfig(request))
  def cancelContact(request: CancelContactRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.CancelContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelContact(request))
  def getMinuteUsage(request: GetMinuteUsageRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.GetMinuteUsageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMinuteUsage(request))
  def listMissionProfiles(request: ListMissionProfilesRequest): ZStream[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.MissionProfileListItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listMissionProfiles(request))
  def listMissionProfilesPaginated(request: ListMissionProfilesRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.ListMissionProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMissionProfilesPaginated(request))
  def getDataflowEndpointGroup(request: GetDataflowEndpointGroupRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.GetDataflowEndpointGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataflowEndpointGroup(request))
  def createDataflowEndpointGroup(
      request: CreateDataflowEndpointGroupRequest
  ): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.CreateDataflowEndpointGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataflowEndpointGroup(request))
  def updateMissionProfile(request: UpdateMissionProfileRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.UpdateMissionProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMissionProfile(request))
  def getConfig(request: GetConfigRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.GetConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getConfig(request))
  def listSatellites(request: ListSatellitesRequest): ZStream[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.SatelliteListItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listSatellites(request))
  def listSatellitesPaginated(request: ListSatellitesRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.ListSatellitesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSatellitesPaginated(request))
  def getSatellite(request: GetSatelliteRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.GetSatelliteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSatellite(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def describeContact(request: DescribeContactRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.DescribeContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeContact(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def deleteMissionProfile(request: DeleteMissionProfileRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.DeleteMissionProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMissionProfile(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def getMissionProfile(request: GetMissionProfileRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.GetMissionProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMissionProfile(request))
  def listContacts(request: ListContactsRequest): ZStream[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.ContactData.ReadOnly
  ] = ZStream.serviceWithStream(_.listContacts(request))
  def listContactsPaginated(request: ListContactsRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.ListContactsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listContactsPaginated(request))
  def deleteDataflowEndpointGroup(
      request: DeleteDataflowEndpointGroupRequest
  ): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.DeleteDataflowEndpointGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataflowEndpointGroup(request))
  def reserveContact(request: ReserveContactRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.ReserveContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.reserveContact(request))
  def createMissionProfile(request: CreateMissionProfileRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.CreateMissionProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMissionProfile(request))
  def updateConfig(request: UpdateConfigRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.UpdateConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConfig(request))
  def listGroundStations(request: ListGroundStationsRequest): ZStream[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.GroundStationData.ReadOnly
  ] = ZStream.serviceWithStream(_.listGroundStations(request))
  def listGroundStationsPaginated(request: ListGroundStationsRequest): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.ListGroundStationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGroundStationsPaginated(request))
  def listDataflowEndpointGroups(
      request: ListDataflowEndpointGroupsRequest
  ): ZStream[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.DataflowEndpointListItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataflowEndpointGroups(request))
  def listDataflowEndpointGroupsPaginated(
      request: ListDataflowEndpointGroupsRequest
  ): ZIO[
    zio.aws.groundstation.GroundStation,
    AwsError,
    zio.aws.groundstation.model.ListDataflowEndpointGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataflowEndpointGroupsPaginated(request))
}
