package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.ConfigArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UplinkEchoConfig(
    antennaUplinkConfigArn: ConfigArn,
    enabled: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.UplinkEchoConfig = {
    import UplinkEchoConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.UplinkEchoConfig
      .builder()
      .antennaUplinkConfigArn(
        ConfigArn.unwrap(antennaUplinkConfigArn): java.lang.String
      )
      .enabled(enabled: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.UplinkEchoConfig.ReadOnly =
    zio.aws.groundstation.model.UplinkEchoConfig.wrap(buildAwsValue())
}
object UplinkEchoConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.UplinkEchoConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.UplinkEchoConfig =
      zio.aws.groundstation.model
        .UplinkEchoConfig(antennaUplinkConfigArn, enabled)
    def antennaUplinkConfigArn: ConfigArn
    def enabled: Boolean
    def getAntennaUplinkConfigArn: ZIO[Any, Nothing, ConfigArn] =
      ZIO.succeed(antennaUplinkConfigArn)
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.UplinkEchoConfig
  ) extends zio.aws.groundstation.model.UplinkEchoConfig.ReadOnly {
    override val antennaUplinkConfigArn: ConfigArn =
      zio.aws.groundstation.model.primitives
        .ConfigArn(impl.antennaUplinkConfigArn())
    override val enabled: Boolean = impl.enabled(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.UplinkEchoConfig
  ): zio.aws.groundstation.model.UplinkEchoConfig.ReadOnly = new Wrapper(impl)
}
