package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TrackingConfig(
    autotrack: zio.aws.groundstation.model.Criticality
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.TrackingConfig = {
    import TrackingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.TrackingConfig
      .builder()
      .autotrack(autotrack.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.TrackingConfig.ReadOnly =
    zio.aws.groundstation.model.TrackingConfig.wrap(buildAwsValue())
}
object TrackingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.TrackingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.TrackingConfig =
      zio.aws.groundstation.model.TrackingConfig(autotrack)
    def autotrack: zio.aws.groundstation.model.Criticality
    def getAutotrack
        : ZIO[Any, Nothing, zio.aws.groundstation.model.Criticality] =
      ZIO.succeed(autotrack)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.TrackingConfig
  ) extends zio.aws.groundstation.model.TrackingConfig.ReadOnly {
    override val autotrack: zio.aws.groundstation.model.Criticality =
      zio.aws.groundstation.model.Criticality.wrap(impl.autotrack())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.TrackingConfig
  ): zio.aws.groundstation.model.TrackingConfig.ReadOnly = new Wrapper(impl)
}
