package zio.aws.groundstation.model
import scala.jdk.CollectionConverters.*
sealed trait Polarization {
  def unwrap: software.amazon.awssdk.services.groundstation.model.Polarization
}
object Polarization {
  def wrap(
      value: software.amazon.awssdk.services.groundstation.model.Polarization
  ): zio.aws.groundstation.model.Polarization = value match {
    case software.amazon.awssdk.services.groundstation.model.Polarization.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.groundstation.model.Polarization.LEFT_HAND =>
      val r = LEFT_HAND
      r
    case software.amazon.awssdk.services.groundstation.model.Polarization.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.groundstation.model.Polarization.RIGHT_HAND =>
      val r = RIGHT_HAND
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.groundstation.model.Polarization {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.Polarization =
      software.amazon.awssdk.services.groundstation.model.Polarization.UNKNOWN_TO_SDK_VERSION
  }
  case object LEFT_HAND extends zio.aws.groundstation.model.Polarization {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.Polarization =
      software.amazon.awssdk.services.groundstation.model.Polarization.LEFT_HAND
  }
  case object NONE extends zio.aws.groundstation.model.Polarization {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.Polarization =
      software.amazon.awssdk.services.groundstation.model.Polarization.NONE
  }
  case object RIGHT_HAND extends zio.aws.groundstation.model.Polarization {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.Polarization =
      software.amazon.awssdk.services.groundstation.model.Polarization.RIGHT_HAND
  }
}
