package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListGroundStationsRequest(
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None,
    satelliteId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest = {
    import ListGroundStationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest
      .builder()
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(satelliteId.map(value => value: java.lang.String))(
        _.satelliteId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.ListGroundStationsRequest.ReadOnly =
    zio.aws.groundstation.model.ListGroundStationsRequest.wrap(buildAwsValue())
}
object ListGroundStationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ListGroundStationsRequest =
      zio.aws.groundstation.model.ListGroundStationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        satelliteId.map(value => value)
      )
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def satelliteId: Option[String]
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSatelliteId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("satelliteId", satelliteId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest
  ) extends zio.aws.groundstation.model.ListGroundStationsRequest.ReadOnly {
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val satelliteId: Option[String] =
      scala.Option(impl.satelliteId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest
  ): zio.aws.groundstation.model.ListGroundStationsRequest.ReadOnly =
    new Wrapper(impl)
}
