package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDataflowEndpointGroupsRequest(
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest = {
    import ListDataflowEndpointGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest
      .builder()
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.ListDataflowEndpointGroupsRequest.ReadOnly =
    zio.aws.groundstation.model.ListDataflowEndpointGroupsRequest
      .wrap(buildAwsValue())
}
object ListDataflowEndpointGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.groundstation.model.ListDataflowEndpointGroupsRequest =
      zio.aws.groundstation.model.ListDataflowEndpointGroupsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest
  ) extends zio.aws.groundstation.model.ListDataflowEndpointGroupsRequest.ReadOnly {
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest
  ): zio.aws.groundstation.model.ListDataflowEndpointGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
