package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.{
  SatelliteArn,
  MissionProfileArn,
  Integer,
  Timestamp
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ListContactsRequest(
    endTime: Timestamp,
    groundStation: Option[String] = None,
    maxResults: Option[Integer] = None,
    missionProfileArn: Option[MissionProfileArn] = None,
    nextToken: Option[String] = None,
    satelliteArn: Option[SatelliteArn] = None,
    startTime: Timestamp,
    statusList: Iterable[zio.aws.groundstation.model.ContactStatus]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ListContactsRequest = {
    import ListContactsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ListContactsRequest
      .builder()
      .endTime(Timestamp.unwrap(endTime): Instant)
      .optionallyWith(groundStation.map(value => value: java.lang.String))(
        _.groundStation
      )
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(
        missionProfileArn.map(value =>
          MissionProfileArn.unwrap(value): java.lang.String
        )
      )(_.missionProfileArn)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        satelliteArn.map(value => SatelliteArn.unwrap(value): java.lang.String)
      )(_.satelliteArn)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .statusListWithStrings(statusList.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ListContactsRequest.ReadOnly =
    zio.aws.groundstation.model.ListContactsRequest.wrap(buildAwsValue())
}
object ListContactsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ListContactsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ListContactsRequest =
      zio.aws.groundstation.model.ListContactsRequest(
        endTime,
        groundStation.map(value => value),
        maxResults.map(value => value),
        missionProfileArn.map(value => value),
        nextToken.map(value => value),
        satelliteArn.map(value => value),
        startTime,
        statusList
      )
    def endTime: Timestamp
    def groundStation: Option[String]
    def maxResults: Option[Integer]
    def missionProfileArn: Option[MissionProfileArn]
    def nextToken: Option[String]
    def satelliteArn: Option[SatelliteArn]
    def startTime: Timestamp
    def statusList: List[zio.aws.groundstation.model.ContactStatus]
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getGroundStation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groundStation", groundStation)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getMissionProfileArn: ZIO[Any, AwsError, MissionProfileArn] =
      AwsError.unwrapOptionField("missionProfileArn", missionProfileArn)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSatelliteArn: ZIO[Any, AwsError, SatelliteArn] =
      AwsError.unwrapOptionField("satelliteArn", satelliteArn)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getStatusList
        : ZIO[Any, Nothing, List[zio.aws.groundstation.model.ContactStatus]] =
      ZIO.succeed(statusList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ListContactsRequest
  ) extends zio.aws.groundstation.model.ListContactsRequest.ReadOnly {
    override val endTime: Timestamp =
      zio.aws.groundstation.model.primitives.Timestamp(impl.endTime())
    override val groundStation: Option[String] =
      scala.Option(impl.groundStation()).map(value => value: String)
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val missionProfileArn: Option[MissionProfileArn] = scala
      .Option(impl.missionProfileArn())
      .map(value =>
        zio.aws.groundstation.model.primitives.MissionProfileArn(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val satelliteArn: Option[SatelliteArn] = scala
      .Option(impl.satelliteArn())
      .map(value => zio.aws.groundstation.model.primitives.SatelliteArn(value))
    override val startTime: Timestamp =
      zio.aws.groundstation.model.primitives.Timestamp(impl.startTime())
    override val statusList: List[zio.aws.groundstation.model.ContactStatus] =
      impl
        .statusList()
        .asScala
        .map { item =>
          zio.aws.groundstation.model.ContactStatus.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ListContactsRequest
  ): zio.aws.groundstation.model.ListContactsRequest.ReadOnly = new Wrapper(
    impl
  )
}
