package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListConfigsRequest(
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ListConfigsRequest = {
    import ListConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ListConfigsRequest
      .builder()
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ListConfigsRequest.ReadOnly =
    zio.aws.groundstation.model.ListConfigsRequest.wrap(buildAwsValue())
}
object ListConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ListConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ListConfigsRequest =
      zio.aws.groundstation.model.ListConfigsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ListConfigsRequest
  ) extends zio.aws.groundstation.model.ListConfigsRequest.ReadOnly {
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ListConfigsRequest
  ): zio.aws.groundstation.model.ListConfigsRequest.ReadOnly = new Wrapper(impl)
}
