package zio.aws.groundstation.model
import scala.jdk.CollectionConverters.*
sealed trait EndpointStatus {
  def unwrap: software.amazon.awssdk.services.groundstation.model.EndpointStatus
}
object EndpointStatus {
  def wrap(
      value: software.amazon.awssdk.services.groundstation.model.EndpointStatus
  ): zio.aws.groundstation.model.EndpointStatus = value match {
    case software.amazon.awssdk.services.groundstation.model.EndpointStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.groundstation.model.EndpointStatus.CREATED =>
      val r = created
      r
    case software.amazon.awssdk.services.groundstation.model.EndpointStatus.CREATING =>
      val r = creating
      r
    case software.amazon.awssdk.services.groundstation.model.EndpointStatus.DELETED =>
      val r = deleted
      r
    case software.amazon.awssdk.services.groundstation.model.EndpointStatus.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.groundstation.model.EndpointStatus.FAILED =>
      val r = failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.groundstation.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EndpointStatus =
      software.amazon.awssdk.services.groundstation.model.EndpointStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object created extends zio.aws.groundstation.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EndpointStatus =
      software.amazon.awssdk.services.groundstation.model.EndpointStatus.CREATED
  }
  case object creating extends zio.aws.groundstation.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EndpointStatus =
      software.amazon.awssdk.services.groundstation.model.EndpointStatus.CREATING
  }
  case object deleted extends zio.aws.groundstation.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EndpointStatus =
      software.amazon.awssdk.services.groundstation.model.EndpointStatus.DELETED
  }
  case object deleting extends zio.aws.groundstation.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EndpointStatus =
      software.amazon.awssdk.services.groundstation.model.EndpointStatus.DELETING
  }
  case object failed extends zio.aws.groundstation.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EndpointStatus =
      software.amazon.awssdk.services.groundstation.model.EndpointStatus.FAILED
  }
}
