package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.JsonString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DecodeConfig(unvalidatedJSON: JsonString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DecodeConfig = {
    import DecodeConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DecodeConfig
      .builder()
      .unvalidatedJSON(JsonString.unwrap(unvalidatedJSON): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.DecodeConfig.ReadOnly =
    zio.aws.groundstation.model.DecodeConfig.wrap(buildAwsValue())
}
object DecodeConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DecodeConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.DecodeConfig =
      zio.aws.groundstation.model.DecodeConfig(unvalidatedJSON)
    def unvalidatedJSON: JsonString
    def getUnvalidatedJSON: ZIO[Any, Nothing, JsonString] =
      ZIO.succeed(unvalidatedJSON)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DecodeConfig
  ) extends zio.aws.groundstation.model.DecodeConfig.ReadOnly {
    override val unvalidatedJSON: JsonString =
      zio.aws.groundstation.model.primitives.JsonString(impl.unvalidatedJSON())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DecodeConfig
  ): zio.aws.groundstation.model.DecodeConfig.ReadOnly = new Wrapper(impl)
}
