package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DataflowDetail(
    destination: Option[zio.aws.groundstation.model.Destination] = None,
    errorMessage: Option[String] = None,
    source: Option[zio.aws.groundstation.model.Source] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DataflowDetail = {
    import DataflowDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DataflowDetail
      .builder()
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.DataflowDetail.ReadOnly =
    zio.aws.groundstation.model.DataflowDetail.wrap(buildAwsValue())
}
object DataflowDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DataflowDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.DataflowDetail =
      zio.aws.groundstation.model.DataflowDetail(
        destination.map(value => value.asEditable),
        errorMessage.map(value => value),
        source.map(value => value.asEditable)
      )
    def destination: Option[zio.aws.groundstation.model.Destination.ReadOnly]
    def errorMessage: Option[String]
    def source: Option[zio.aws.groundstation.model.Source.ReadOnly]
    def getDestination
        : ZIO[Any, AwsError, zio.aws.groundstation.model.Destination.ReadOnly] =
      AwsError.unwrapOptionField("destination", destination)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getSource
        : ZIO[Any, AwsError, zio.aws.groundstation.model.Source.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DataflowDetail
  ) extends zio.aws.groundstation.model.DataflowDetail.ReadOnly {
    override val destination
        : Option[zio.aws.groundstation.model.Destination.ReadOnly] = scala
      .Option(impl.destination())
      .map(value => zio.aws.groundstation.model.Destination.wrap(value))
    override val errorMessage: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
    override val source: Option[zio.aws.groundstation.model.Source.ReadOnly] =
      scala
        .Option(impl.source())
        .map(value => zio.aws.groundstation.model.Source.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DataflowDetail
  ): zio.aws.groundstation.model.DataflowDetail.ReadOnly = new Wrapper(impl)
}
