package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CancelContactRequest(contactId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.CancelContactRequest = {
    import CancelContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.CancelContactRequest
      .builder()
      .contactId(contactId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.CancelContactRequest.ReadOnly =
    zio.aws.groundstation.model.CancelContactRequest.wrap(buildAwsValue())
}
object CancelContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.CancelContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.CancelContactRequest =
      zio.aws.groundstation.model.CancelContactRequest(contactId)
    def contactId: String
    def getContactId: ZIO[Any, Nothing, String] = ZIO.succeed(contactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.CancelContactRequest
  ) extends zio.aws.groundstation.model.CancelContactRequest.ReadOnly {
    override val contactId: String = impl.contactId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.CancelContactRequest
  ): zio.aws.groundstation.model.CancelContactRequest.ReadOnly = new Wrapper(
    impl
  )
}
