package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AntennaUplinkConfig(
    spectrumConfig: zio.aws.groundstation.model.UplinkSpectrumConfig,
    targetEirp: zio.aws.groundstation.model.Eirp,
    transmitDisabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.AntennaUplinkConfig = {
    import AntennaUplinkConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.AntennaUplinkConfig
      .builder()
      .spectrumConfig(spectrumConfig.buildAwsValue())
      .targetEirp(targetEirp.buildAwsValue())
      .optionallyWith(transmitDisabled.map(value => value: java.lang.Boolean))(
        _.transmitDisabled
      )
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.AntennaUplinkConfig.ReadOnly =
    zio.aws.groundstation.model.AntennaUplinkConfig.wrap(buildAwsValue())
}
object AntennaUplinkConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.AntennaUplinkConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.AntennaUplinkConfig =
      zio.aws.groundstation.model.AntennaUplinkConfig(
        spectrumConfig.asEditable,
        targetEirp.asEditable,
        transmitDisabled.map(value => value)
      )
    def spectrumConfig
        : zio.aws.groundstation.model.UplinkSpectrumConfig.ReadOnly
    def targetEirp: zio.aws.groundstation.model.Eirp.ReadOnly
    def transmitDisabled: Option[Boolean]
    def getSpectrumConfig: ZIO[
      Any,
      Nothing,
      zio.aws.groundstation.model.UplinkSpectrumConfig.ReadOnly
    ] = ZIO.succeed(spectrumConfig)
    def getTargetEirp
        : ZIO[Any, Nothing, zio.aws.groundstation.model.Eirp.ReadOnly] =
      ZIO.succeed(targetEirp)
    def getTransmitDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("transmitDisabled", transmitDisabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.AntennaUplinkConfig
  ) extends zio.aws.groundstation.model.AntennaUplinkConfig.ReadOnly {
    override val spectrumConfig
        : zio.aws.groundstation.model.UplinkSpectrumConfig.ReadOnly =
      zio.aws.groundstation.model.UplinkSpectrumConfig
        .wrap(impl.spectrumConfig())
    override val targetEirp: zio.aws.groundstation.model.Eirp.ReadOnly =
      zio.aws.groundstation.model.Eirp.wrap(impl.targetEirp())
    override val transmitDisabled: Option[Boolean] =
      scala.Option(impl.transmitDisabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.AntennaUplinkConfig
  ): zio.aws.groundstation.model.AntennaUplinkConfig.ReadOnly = new Wrapper(
    impl
  )
}
