package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UplinkSpectrumConfig(
    centerFrequency: zio.aws.groundstation.model.Frequency,
    polarization: Option[zio.aws.groundstation.model.Polarization] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.UplinkSpectrumConfig = {
    import UplinkSpectrumConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.UplinkSpectrumConfig
      .builder()
      .centerFrequency(centerFrequency.buildAwsValue())
      .optionallyWith(polarization.map(value => value.unwrap))(_.polarization)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.UplinkSpectrumConfig.ReadOnly =
    zio.aws.groundstation.model.UplinkSpectrumConfig.wrap(buildAwsValue())
}
object UplinkSpectrumConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.UplinkSpectrumConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.UplinkSpectrumConfig =
      zio.aws.groundstation.model.UplinkSpectrumConfig(
        centerFrequency.asEditable,
        polarization.map(value => value)
      )
    def centerFrequency: zio.aws.groundstation.model.Frequency.ReadOnly
    def polarization: Option[zio.aws.groundstation.model.Polarization]
    def getCenterFrequency
        : ZIO[Any, Nothing, zio.aws.groundstation.model.Frequency.ReadOnly] =
      ZIO.succeed(centerFrequency)
    def getPolarization
        : ZIO[Any, AwsError, zio.aws.groundstation.model.Polarization] =
      AwsError.unwrapOptionField("polarization", polarization)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.UplinkSpectrumConfig
  ) extends zio.aws.groundstation.model.UplinkSpectrumConfig.ReadOnly {
    override val centerFrequency
        : zio.aws.groundstation.model.Frequency.ReadOnly =
      zio.aws.groundstation.model.Frequency.wrap(impl.centerFrequency())
    override val polarization
        : Option[zio.aws.groundstation.model.Polarization] = scala
      .Option(impl.polarization())
      .map(value => zio.aws.groundstation.model.Polarization.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.UplinkSpectrumConfig
  ): zio.aws.groundstation.model.UplinkSpectrumConfig.ReadOnly = new Wrapper(
    impl
  )
}
