package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.ConfigArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateConfigResponse(
    configArn: Option[ConfigArn] = None,
    configId: Option[String] = None,
    configType: Option[zio.aws.groundstation.model.ConfigCapabilityType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.UpdateConfigResponse = {
    import UpdateConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.UpdateConfigResponse
      .builder()
      .optionallyWith(
        configArn.map(value => ConfigArn.unwrap(value): java.lang.String)
      )(_.configArn)
      .optionallyWith(configId.map(value => value: java.lang.String))(
        _.configId
      )
      .optionallyWith(configType.map(value => value.unwrap))(_.configType)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.UpdateConfigResponse.ReadOnly =
    zio.aws.groundstation.model.UpdateConfigResponse.wrap(buildAwsValue())
}
object UpdateConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.UpdateConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.UpdateConfigResponse =
      zio.aws.groundstation.model.UpdateConfigResponse(
        configArn.map(value => value),
        configId.map(value => value),
        configType.map(value => value)
      )
    def configArn: Option[ConfigArn]
    def configId: Option[String]
    def configType: Option[zio.aws.groundstation.model.ConfigCapabilityType]
    def getConfigArn: ZIO[Any, AwsError, ConfigArn] =
      AwsError.unwrapOptionField("configArn", configArn)
    def getConfigId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configId", configId)
    def getConfigType
        : ZIO[Any, AwsError, zio.aws.groundstation.model.ConfigCapabilityType] =
      AwsError.unwrapOptionField("configType", configType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.UpdateConfigResponse
  ) extends zio.aws.groundstation.model.UpdateConfigResponse.ReadOnly {
    override val configArn: Option[ConfigArn] = scala
      .Option(impl.configArn())
      .map(value => zio.aws.groundstation.model.primitives.ConfigArn(value))
    override val configId: Option[String] =
      scala.Option(impl.configId()).map(value => value: String)
    override val configType
        : Option[zio.aws.groundstation.model.ConfigCapabilityType] = scala
      .Option(impl.configType())
      .map(value =>
        zio.aws.groundstation.model.ConfigCapabilityType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.UpdateConfigResponse
  ): zio.aws.groundstation.model.UpdateConfigResponse.ReadOnly = new Wrapper(
    impl
  )
}
