package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: String,
    tagKeys: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.UntagResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .tagKeys(tagKeys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.UntagResourceRequest.ReadOnly =
    zio.aws.groundstation.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.UntagResourceRequest =
      zio.aws.groundstation.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: String
    def tagKeys: List[String]
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.UntagResourceRequest
  ) extends zio.aws.groundstation.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
    override val tagKeys: List[String] = impl
      .tagKeys()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.UntagResourceRequest
  ): zio.aws.groundstation.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
