package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Eirp(
    units: zio.aws.groundstation.model.EirpUnits,
    value: Double
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.Eirp = {
    import Eirp.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.Eirp
      .builder()
      .units(units.unwrap)
      .value(value: java.lang.Double)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.Eirp.ReadOnly =
    zio.aws.groundstation.model.Eirp.wrap(buildAwsValue())
}
object Eirp {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.Eirp
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.Eirp =
      zio.aws.groundstation.model.Eirp(units, value)
    def units: zio.aws.groundstation.model.EirpUnits
    def value: Double
    def getUnits: ZIO[Any, Nothing, zio.aws.groundstation.model.EirpUnits] =
      ZIO.succeed(units)
    def getValue: ZIO[Any, Nothing, Double] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.Eirp
  ) extends zio.aws.groundstation.model.Eirp.ReadOnly {
    override val units: zio.aws.groundstation.model.EirpUnits =
      zio.aws.groundstation.model.EirpUnits.wrap(impl.units())
    override val value: Double = impl.value(): Double
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.Eirp
  ): zio.aws.groundstation.model.Eirp.ReadOnly = new Wrapper(impl)
}
