package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDataflowEndpointGroupResponse(
    dataflowEndpointGroupId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupResponse = {
    import CreateDataflowEndpointGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupResponse
      .builder()
      .optionallyWith(
        dataflowEndpointGroupId.map(value => value: java.lang.String)
      )(_.dataflowEndpointGroupId)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.CreateDataflowEndpointGroupResponse.ReadOnly =
    zio.aws.groundstation.model.CreateDataflowEndpointGroupResponse
      .wrap(buildAwsValue())
}
object CreateDataflowEndpointGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.groundstation.model.CreateDataflowEndpointGroupResponse =
      zio.aws.groundstation.model.CreateDataflowEndpointGroupResponse(
        dataflowEndpointGroupId.map(value => value)
      )
    def dataflowEndpointGroupId: Option[String]
    def getDataflowEndpointGroupId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dataflowEndpointGroupId", dataflowEndpointGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupResponse
  ) extends zio.aws.groundstation.model.CreateDataflowEndpointGroupResponse.ReadOnly {
    override val dataflowEndpointGroupId: Option[String] =
      scala.Option(impl.dataflowEndpointGroupId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupResponse
  ): zio.aws.groundstation.model.CreateDataflowEndpointGroupResponse.ReadOnly =
    new Wrapper(impl)
}
