package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDataflowEndpointGroupRequest(
    endpointDetails: Iterable[zio.aws.groundstation.model.EndpointDetails],
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupRequest = {
    import CreateDataflowEndpointGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupRequest
      .builder()
      .endpointDetails(endpointDetails.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.CreateDataflowEndpointGroupRequest.ReadOnly =
    zio.aws.groundstation.model.CreateDataflowEndpointGroupRequest
      .wrap(buildAwsValue())
}
object CreateDataflowEndpointGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.groundstation.model.CreateDataflowEndpointGroupRequest =
      zio.aws.groundstation.model.CreateDataflowEndpointGroupRequest(
        endpointDetails.map { item =>
          item.asEditable
        },
        tags.map(value => value)
      )
    def endpointDetails
        : List[zio.aws.groundstation.model.EndpointDetails.ReadOnly]
    def tags: Option[Map[String, String]]
    def getEndpointDetails: ZIO[Any, Nothing, List[
      zio.aws.groundstation.model.EndpointDetails.ReadOnly
    ]] = ZIO.succeed(endpointDetails)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupRequest
  ) extends zio.aws.groundstation.model.CreateDataflowEndpointGroupRequest.ReadOnly {
    override val endpointDetails
        : List[zio.aws.groundstation.model.EndpointDetails.ReadOnly] = impl
      .endpointDetails()
      .asScala
      .map { item =>
        zio.aws.groundstation.model.EndpointDetails.wrap(item)
      }
      .toList
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupRequest
  ): zio.aws.groundstation.model.CreateDataflowEndpointGroupRequest.ReadOnly =
    new Wrapper(impl)
}
